#!/bin/sh
#
# Get MAC address of Bluetooth device

set -e

show_help()
{
cat << EOF
Usage:
	factory_tool get_bt_mac

Description:
	Get Bluetooth MAC address of device.

Parameters:
	This command doesn't expect any parameters.

EOF
}

# Check for help or other parameters
if [ $# -eq 1 ] && [ "$1" = "help" ]; then
	show_help
	exit 0
elif [ $# -ne 0 ]; then
	echo "Error: Command doesn't expect any parameters"
	show_help
	exit 1
fi

hcitool dev | grep -o "[[:xdigit:]:]\{12,17\}"
exit 0
