#!/bin/sh
#
# Get StreamSDK version

set -e

if [ $# -eq 0 ]; then
	# Separate error handling
	set +e
	# Check if StreamSDK is running, since nsdk_cli depends on it
	if ! pgrep -x "nSDK" > /dev/null; then
		echo "Error: StreamSDK is not running"
		exit 1
	fi
	set -e
	nsdk_cli get settings:/version
	exit 0
else
	echo "Command doesn't expect any parameters"
	exit 1
fi
