#!/bin/sh
#
# Test the availability of the Apple authentication chip

if [ $# -eq 0 ]; then
	SET="/settings-default/appleAuthChip/"
	CARRIER=`cat /proc/device-tree/sue/carrierboard`
	I2CDEV=`jq -r '.value.string_' $SET/device-$CARRIER 2> /dev/null || jq -r '.value.string_' $SET/device`
	I2CADDR=`jq -r '.value.string_' $SET/address-$CARRIER 2> /dev/null || jq -r '.value.string_' $SET/address`

	authchip_test $I2CDEV $I2CADDR
	if [ $? -eq 0 ]; then
		echo "Authentication Chip check PASSED"
		exit 0
	else
		echo "Error: Authentication Chip check FAILED"
		exit 1
	fi
else
	# If extra arguments are provided
	echo "Error: Command doesn't expect any parameters"
	exit 1
fi
