<!DOCTYPE html>
<html>
	<head>
		<meta content="text/html;charset=utf-8" http-equiv="Content-Type">

		<title><?nsdk getData path="settings:/system/modelName" roles="value" escape="html"?> &ndash; Network Settings</title>
		<link rel="stylesheet" type="text/css" href="/style/style.css">
		<link rel="stylesheet" type="text/css" href="/style/jquery-ui.min.css">

		<script type="text/javascript" src="/jsapi/jquery.min.js"></script>
		<script type="text/javascript" src="/jsapi/jquery-ui.min.js"></script>
		<script type="text/javascript" src="/jsapi/nsdk-api.js"></script>
		<script type="text/javascript" src="/jsapi/common.js"></script>
		<script type="text/javascript" src="/scripts/menu.js.fcgi"></script>

		<script type="text/javascript">

			var networkRepeatTime = 1500;
			var networkConnectTime = 30000;
			var networkStartTime = 0;

			$(document).ready(function() {
				$("#networkConfig").load("networkContent.fcgi");

				$("#dialog").dialog({
					autoOpen: false
				});
			});

			function requestDummySoftAp() {
				NSDK_Activate("network:requestSoftAp", {"type":"networkSoftApRequest",
					"networkSoftApRequest": {"name": "www", "timeout": networkConnectTime, "holdSoftAp": true}});
			}

			function revokeDummySoftAp() {
				NSDK_Activate("network:revokeSoftAp", {"type":"networkSoftApRequest",
					"networkSoftApRequest": {"name": "www"}});
			}

			function setNetworkProfile(profile, info) {
				// check if we are connected over softAp
				if (info !== undefined && info.networkInfo !== undefined && info.networkInfo.softAp !== undefined &&
							info.networkInfo.softAp.state == "up") {
					requestDummySoftAp();
				}
				NSDK_Activate("network:setNetworkProfile", profile).done(function() {
					networkStartTime = performance.now();
					setTimeout(getNewIpAddress, networkRepeatTime);
					$("#dialog").dialog("option", "title", "Network settings...");
					$("#dialog").html('Applying network settings...');
					$("#dialog").dialog("widget").find('.ui-dialog-titlebar-close').remove();
					$("#dialog").dialog("open");
				}).fail(function() {
					revokeDummySoftAp();
					alert("Applying the new network settings failed");
				});
			}

			function setNetworkFinished(ip) {
				// show dialog with redirect link
				revokeDummySoftAp();
				$("#dialog").html("Please wait till your device connects to selected network and " +
					"continue <a href=//"+ ip + "/network.fcgi>here</a>");
			}

			function setNetworkTimeout() {
				revokeDummySoftAp();
				$("#dialog").dialog("close");
				alert("Applying the new network settings failed");
			}

			function getNewIpAddress() {
				NSDK_GetData("network:info", "value").done(function(result) {
					var profile = result["value"];

					if (performance.now() - networkStartTime > networkConnectTime) {
						setNetworkTimeout();
						return;
					}

					var reload = false, ip;
					if (profile.networkInfo && profile.networkInfo.wireless && profile.networkInfo.wireless.state == "up" &&
							profile.networkInfo.wireless.addresses && profile.networkInfo.wireless.addresses[0].ip) {
						ip = profile.networkInfo.wireless.addresses[0].ip;
						reload = true;
					}

					if (profile.networkInfo && profile.networkInfo.wired &&  profile.networkInfo.wired.state == "up" &&
							profile.networkInfo.wired.addresses && profile.networkInfo.wired.addresses[0].ip) {
						ip = profile.networkInfo.wired.addresses[0].ip;
						reload = true;
					}

					if (reload) {
						setNetworkFinished(ip)
					} else {
						console.log("Wired and Wireless connection undefined/down");
						setTimeout(getNewIpAddress, networkRepeatTime);
					}
				})
				.fail(function() {
					if (performance.now() - networkStartTime > networkConnectTime) {
						setNetworkTimeout();
					} else {
						setTimeout(getNewIpAddress, networkRepeatTime);
					}
				});
			}

		</script>
	</head>
	<body>
		<div id="menu"></div>
		<div id="networkConfig"></div>
		<div id="dialog"></div>
	</body>
</html>
