$(document).ready(function () {
  const defaultValues = "210132000200000D";
  const emptyDevices = ["No paired devices"];

  $("#clear-paired-devices").on("click", confirmClearPairedDevices);

  $("#pair-device").on("click", function() {
    showAlert("Now discoverable", $(this), 10000);
    window.webSocket.send(0x32, [0x01, 0x00]);
  });

  startup();

  function startup() {
    restorePreviousValues();

    window.socketMessageReceived = function(msg) {
      displayPairedDevices(parseBluetoothBuffer(msg));
    };

    window.webSocket.send(0x32, [0xF0]);
  }

  function restorePreviousValues() {
    const devices = parseBluetoothBuffer(hexStringToByte(defaultValues));
    displayPairedDevices(devices);
  }

  function parseBluetoothBuffer(buffer) {
    if (buffer.length < 8) {
      throw "Invalid buffer length: " + buffer.length;
    }

    if (!validateCommandCode(buffer, 0x32)) {
      throw "Invalid command code.";
    }

    // Check the data length is divisible by 20, if not set to no paired devices.
    // Note: subtract 2 for the two read-only bytes at the start of the data.
    const dataLength = buffer[4] - 2;
    if (dataLength % 20 != 0 || dataLength == 0) {
      return emptyDevices;
    }

    // Strip the first two data bytes as they're always 00 00
    var data = buffer.slice(7, buffer.length - 1);

    // Loop through and parse device names
    var devices = [];
    const items = data.length / 20;

    for (let i = 0; i < items; i++) {
      const min = i * 20;
      const max = min + 20;
      const device = Utils.asciiFromBuffer(data, {
        "min": min,
        "max": max
      });
      devices.push(device);
    }

    return devices;
  }

  function displayPairedDevices(devices) {
    var elements = $.map(devices, function(device, i) {
      return '<li class="list-group-item">' + device + '</li>';
    });

    $("#paired-devices").empty().append(elements);
  }

  function confirmClearPairedDevices() {
    const message = "Are you sure you want to clear all paired devices?";
    if (confirm(message)) {
      clearPairedDevices();
    }
  }

  function clearPairedDevices() {
    displayPairedDevices(emptyDevices);
    window.webSocket.send(0x32, [0x00, 0x01]);
  }
});
