#! /bin/sh

FIRMWARE_BASE_PATH="/lib/firmware"
VERSIONS_JSON=$FIRMWARE_BASE_PATH"/versions.json"

# retrieve upgrade files to exclude
# note: This will always be the current model's firmware file, but in the case of AVRs, it may also include the file for the HDMI2.1
# version; ARCAM offering users to upgrade their existing units to HDMI2.1 breaks the assumption that the reported device model will
# always be the same. For example, if the reported model identifier is arc_avr30, we'll also exclude arc_avr30_8k's file. 
excludedUpgradeFiles=`cat $VERSIONS_JSON | jq -r '. as $o | keys_unsorted[] | select(startswith("'$deviceModel'")) | $o[.].file'`

# retrieve a list of all upgrade files
fileList=$(jq '.[]' $VERSIONS_JSON | jq -r '.file' | sort | uniq)

# loop over all upgrade files
for upgradeFile in $fileList; do
    removeUpgradeFile=true

    # remove only files that are not on the excluded list
    for excludedFile in $excludedUpgradeFiles; do
        if [ "x$upgradeFile" == "x$excludedFile" ]; then
            removeUpgradeFile=false
        fi
    done

    # if the file exists and is not excluded, remove it
    if $removeUpgradeFile; then
        if [ -f $FIRMWARE_BASE_PATH/$upgradeFile ]; then
            echo -n "Removing $upgradeFile ..."
            rm $FIRMWARE_BASE_PATH/$upgradeFile
            echo " Done."
        fi
    fi
done
