#! /bin/sh

PROFILE="/media/settings/settings/network/profile"

is_null_or_empty()
{
	test "x$1" = "x" -o "x$1" = "xnull"
}

ENC_VALUE="$(jq -rM '.encryptedValue' "$PROFILE" 2>/dev/null)"
if [ -n "$ENC_VALUE" ] && [ "$ENC_VALUE" != "null" ]; then
	# Try to decrypt network profile
	# If something goes wrong, clear NETWORK_PROFILE, so that we fall back to the default one
	NETWORK_PROFILE="$(settings_decrypt -r "$ENC_VALUE" 2>/dev/null)" || NETWORK_PROFILE=''
else
	NETWORK_PROFILE="$(jq -rM '.value' "$PROFILE" 2>/dev/null)"
fi

# fallback in case the profile is not set
if is_null_or_empty "$(echo "$NETWORK_PROFILE" | jq -rM .networkProfile)"; then
	echo '{"networkProfile":{"wired":{"dhcp":true},"type":"automatic"}}'
else
	echo "$NETWORK_PROFILE"
fi
