#!/bin/sh
#
# Lock a113 module
#

set -e

FUSEFILE="/usr/share/factory-tool/files/efuses.bin"

show_help()
{
cat << EOF
Usage:
	factory_tool lock

Description:
	Lock module by burning efuses.

Parameters:
	This command doesn't expect any parameters.

Notes:
	This command has irreversible effect.

EOF
}

# Print result on script execution
print_result()
{
	if [ $? -eq 0 ]; then
		echo "# done locking device"
	else
		echo "# error locking device"
	fi
}

# Check for help or other parameters
if [ $# -eq 1 ] && [ "$1" = "help" ]; then
	show_help
	exit 0
elif [ $# -ne 0 ]; then
	# Some setups may rely on result of print_result() function
	trap print_result EXIT
	echo "Error: Command doesn't expect any parameters"
	show_help
	exit 1
fi

# trap will be only active if paramenters were parsed successfully
trap print_result EXIT

# Check efuses.bin file present
if [ ! -f "$FUSEFILE" ]; then
	echo "Error: Fuse configuration not found"
	exit 1
fi

# Lock a113 module
tee_provision -t 0x51 -i "$FUSEFILE" || exit 1

# remove if exists, will be recreated with a stricter value
rm -f /etc/hwrevision

exit 0
