var assistantList = JSON.parse('<?nsdk getData path="machine:assistantList" roles="value" escape="js"?>');
var activeAssistant = '<?nsdk getData path="machine:activeAssistant" roles="value" escape="js"?>'
var featureList = JSON.parse('<?nsdk getData path="machine:enabledFeatures" roles="value" escape="js"?>');

function isAssistantActive(assistant)
{
	return activeAssistant == assistant;
}

function isFeatureEnabled(feature)
{
	return featureList.stringList.includes(feature)
}

$(document).ready(function()
{
	var menu = '<ul class="menu">'

	// Harman's Setup Utility is only supported on AVRs
	if (isFeatureEnabled("avrsetuputility")) {
		menu += '<li><a href="/setup">Setup</a></li>'
	}

	menu += '\
		<li><a href="/index.fcgi">Main Page</a></li>\
		<li><a href="/settings.fcgi">Device Settings</a></li>\
		<li><a href="/network.fcgi">Network Settings</a></li>\
		';

	// GoogleCast page needs to be shown even if there is no voice assistant, so we can't use isAssistantActive.
	// Assistant state node actually also exists even on non-assistant builds!
	if (isFeatureEnabled("googlecast")) {
		menu += '<li><a href="/googlecast.fcgi">Google Cast</a></li>'
	}
	if (isFeatureEnabled("googlecastlite")) {
		menu += '<li><a href="/googlecastlite.fcgi">Google Cast</a></li>'
	}

	if (isAssistantActive("alexavoiceservice")) {
		menu += '<li><a href="/alexa.fcgi">Alexa Voice</a></li>'
	}

	if (isAssistantActive("tencentxiaowei")) {
		menu += '<li><a href="/xiaowei.fcgi">Tencent Xiaowei</a></li>'
	}

	if (assistantList.stringList.length > 1) {
		menu += '<li><a href="/assistant.fcgi">Assistant Selection</a></li>'
	}

	if (isFeatureEnabled("nymea")) {
		menu += '<li><a href="/nymea.fcgi">Nymea</a></li>'
	}

	if (isFeatureEnabled("reporting")) {
		menu += '<li><a href="/reporting.fcgi">Bug report</a></li>'
	}

	menu +=
		'<li><a href="/webclient">Webclient</a></li>\
		</ul>\
		';

	$("#menu").html(menu);
});
