$(document).ready(function () {
  const powerState = 0x00;
  const volume = 0x0D;
  const mute = 0x0E;
  const incomingFormat = 0x43;
  const stereoDecode = 0x10;
  const mchDecode = 0x11;

  var audioStreamFormat = 0x15;
  var audioChannelConfiguration = 0x21;
  var isMuted = false;
  var currentVolume = 0;

  startup();

  function startup() {
    window.socketMessageReceived = parseMessage;
    setupButtonCallbacks();
    getState();
  }

  function parseMessage(msg) {
      switch (msg[2]) {
        case powerState:
          updatePowerState(msg[5]);
          break;
        case volume:
          updateVolume(msg[5]);
          break;
        case mute:
          updateMute(msg[5]);
          break;
        case incomingFormat:
          updateIncomingFormat(msg[5], msg[6]);
          break;
        case stereoDecode:
          updateStereoDecodeMode(msg[5]);
          break;
        case mchDecode:
          updateMultiChannelDecodeMode(msg[5]);
          break;
        default:
          break;
      }
  }

  function setupButtonCallbacks() {
    $("button#amp-vol-down").on('click', function() {
      window.webSocket.send(0x08, [0x10, 0x11]);
    });

    $("button#amp-vol-up").on('click', function() {
      window.webSocket.send(0x08, [0x10, 0x10]);
    });

    $("button#amp-vol-mute").on('click', function() {
      window.webSocket.send(0x08, [0x10, 0x0D]);
    });

    $("button#amp-power-toggle").on('click', function() {
      window.webSocket.send(0x08, [0x10, 0x0C]);
    });

    $("button#amp-decode-mode").on('click', function() {
      window.webSocket.send(0x08, [0x10, 0x20]);
    });
  }

  function getState() {
    window.webSocket.send(powerState, [0xF0]);
    window.webSocket.send(volume, [0xF0]);
    window.webSocket.send(mute, [0xF0]);
    window.webSocket.send(incomingFormat, [0xF0]);
  }

  function updatePowerState(newState) {
    var powerState = newState === 1 ? "Powered On" : "Standby";
    $("input#amp-power-state").val(powerState);

    var isDisabled = newState === 0;
    $("form button").not("#amp-power-toggle").prop("disabled", isDisabled);
  }

  function updateVolume(newVolume) {
    currentVolume = newVolume;
    updateVolumeLabel();
  }

  function updateMute(newState) {
    isMuted = newState === 0;
    updateVolumeLabel();
  }

  function updateVolumeLabel() {
    var value = isMuted ? "MUTE" : currentVolume;
    $("input#amp-volume").val(value);
  }

  function updateIncomingFormat(format, channels) {
    audioStreamFormat = format;
    audioChannelConfiguration = channels;

    if (isStereo(channels)) {
      window.webSocket.send(stereoDecode, [0xF0]);
    } else {
      window.webSocket.send(mchDecode, [0xF0]);
    }
  }

  function isStereo(channels) {
    return Utils.parseChannelConfig(channels) === "2.0";
  }

  function updateStereoDecodeMode(newMode) {
    displayDecodeMode(Utils.parseStereoDecodeMode(newMode));
  }

  function updateMultiChannelDecodeMode(newMode) {
    displayDecodeMode(Utils.parseMultiChannelDecodeMode(newMode));
  }

  function displayDecodeMode(mode) {
    $("input#amp-decode-mode").val(mode);
  }
});
