#!/bin/sh
set -eu

airableConfigFile="/settings-default/airable/config"
airableConfigFileModelSpecific=$airableConfigFile"_"$deviceModel

# Retrieve the Airable endpoint ID
endpointId=$(jq -r '.value.airableConfig.baseUrl // ""' $airableConfigFile | sed 's/[^0-9]//g')
if [ -f "$airableConfigFileModelSpecific" ]; then
    endpointId=$(jq -r '.value.airableConfig.baseUrl // ""' $airableConfigFileModelSpecific | sed 's/[^0-9]//g')
fi
echo "Airable endpoint ID for '$deviceModel': $endpointId"

# Loop through the default presets and replace all endpoint IDs
echo -n "Updating the baseUrl for all default presets ..."
for file in /settings-default/al/presets/*; do
    if ! grep -q "/$endpointId.airable.io" "$file"; then
        sed -i "s|/[0-9]*.airable.io|/$endpointId.airable.io|g" "$file"
        echo -n "."
    fi
done
echo " Done."

# Loop through the stored user preset and replace all endpoint IDs
if [ -d "/media/settings/settings/al/presets/" ]; then  # Check if the folder exists
    echo -n "Updating the baseUrl for any user presets ..."
    for file in /media/settings/settings/al/presets/*; do
        if ! grep -q "/$endpointId.airable.io" "$file"; then
            sed -i "s|/[0-9]*.airable.io|/$endpointId.airable.io|g" "$file"
            echo -n "."
        fi
    done
    echo " Done."
fi
