#!/bin/sh

RO_SETTINGS_DIR="/settings-default"
RW_SETTINGS_DIR="/media/settings/settings"

_jq()
{
	jq -crM "$@"
}

# Helper function for retrieving content of a setting from a read-only storage.
# If the setting does not exist, an empty string is returned.
get_readonly_settings_value()
{
	local SETTING_NAME="$1"
	if [ -e "$RO_SETTINGS_DIR/$SETTING_NAME" ]; then
		cat "$RO_SETTINGS_DIR/$SETTING_NAME"
	else
		echo ""
	fi
}

# Helper function for retrieving content of a setting from a read/write storage.
# If the setting does not exist, an empty string is returned.
get_readwrite_settings_value()
{
	local SETTING_NAME="$1"
	if [ -e "$RW_SETTINGS_DIR/$SETTING_NAME" ]; then
		cat "$RW_SETTINGS_DIR/$SETTING_NAME"
	else
		echo ""
	fi
}

# Helper function for retrieving content of a setting from a read/write storage,
# and if it does not exist, a read-only storage.
# If the setting does not exist at all, an empty string is returned.
get_settings_value()
{
	local SETTING_NAME="$1"
	local SETTING_VALUE=`get_readwrite_settings_value $SETTING_NAME`
	if [ -z "$SETTING_VALUE" ]; then
		SETTING_VALUE=`get_readonly_settings_value $SETTING_NAME`
	fi
	echo "$SETTING_VALUE"
}
