#!/bin/sh
# Copyright (c) 2007-2014 by StreamUnlimited Engineering GmbH.

# This software is copyrighted by and is the sole property of
# StreamUnlimited Engineering GmbH.

# All rights, title, ownership, or other interests in the software
# remain the property of StreamUnlimited Engineering GmbH. This
# software may only be used in accordance with the corresponding
# license agreement. Any unauthorized use, duplication, transmission,
# distribution, or disclosure of this software is expressly forbidden.

# This Copyright notice may not be removed or modified without prior
# written consent of StreamUnlimited Engineering GmbH.

# StreamUnlimited Engineering GmbH reserves the right to modify this
# software without notice.

# The SCWD_FINISHED string is used by scwd to determine when the dhcp client is
# finished; the output of the dhcp client command is monitored and when
# SCWD_FINISHED is found then scwd considers the connection to be ready.

case "$1" in
	deconfig)
		;;
	renew|bound)
                echo SCWD_INTERFACE=$interface
                echo SCWD_IP=$ip
                echo SCWD_NETMASK=$subnet
                echo SCWD_GATEWAY=$router
                echo SCWD_DNS=$dns
                echo SCWD_DOMAIN=$domain
		echo SCWD_FINISHED
		;;
	nak)
		echo SCWD_NAK $message
esac
