#!/usr/bin/env sh

BDADDR=/usr/bin/bdaddr
HCICONFIG=/usr/bin/hciconfig
FW_PRINTCONST=/sbin/fw_printconst

# these can be multiple commands, will be passed to eval
BT_ATTACH_CMD=""
BT_DETACH_CMD=""

# check if we have hciattach available (it can be missing in swupdate-image)
if [ ! -f "/usr/bin/hciattach" ]; then
	echo "BT tools not available"
	exit 0
fi

# source machine-specific parameters for BT setup
. /etc/brcm/bt_settings.sh

# check if we have hciconfig and bdaddr available (these can be missing in swupdate-image)
if [ ! -f ${HCICONFIG} -o ! -f ${BDADDR} ]; then
	echo "BT tools not available"
	exit 0
fi

bt_addr=`$FW_PRINTCONST -n bt_addr`
if [ $? -eq 0 ]; then
	eval "${BT_ATTACH_CMD}"

	${HCICONFIG} hci0 up
	${BDADDR} -i hci0 $bt_addr
	${HCICONFIG} hci0 reset
	${HCICONFIG} hci0 down
else
	eval "${BT_ATTACH_CMD}"
fi
