#!/bin/sh
#
# Stop StreamSDK, connect to wireless network and get RSSI value

set -e

show_help()
{
cat << EOF
Usage:
	factory_tool test_wlan <SSID> <PSK> <IP-ADDRESS>

Parameters:
	SSID
		SSID of wireless network that DUT should connect to.
		Should not contain spaces.
	PSK
		Password of wireless network that DUT should connect to.
		Should not contain spaces.
	IP-ADDRESS
		It is recommended to select IP address, which is in correct IP
		address range, but not in DHCP pool (to avoid collisions with
		already assigned IP address).
		Example:
			IP address of router - 192.168.50.1; netmask - 255.255.255.0
			DHCP IP address pool - from 192.168.50.100 to 192.168.50.200
			Example address for DUT 192.168.50.90
EOF
}

if [ "$1" = "help" ]; then
	show_help
	exit 0
elif [ $# -ne 3 ]; then
	echo "Error: wrong amount of parameters"
	show_help
	exit 1
fi


SSID="$1"
PSK="$2"
IP="$3"
ATTEMPT=10

# Stop StreamSDK and network
/etc/init.d/nsdk stop
usleep 50000

# Allow to fail in case no wpa_supplicant process is present
pkill wpa_supplicant || true
ip addr flush dev wlan0
ip link set dev wlan0 down

# Allow to fail in case such processes are not present
pkill udhcpd || true
pkill hostapd || true
ip addr flush dev uap0
ip link set dev uap0 down
usleep 50000

# Connect to specific network
wpa_passphrase "$SSID" "$PSK" > /tmp/wifi.conf
wpa_supplicant -c /tmp/wifi.conf -i wlan0 -B
sleep 5

# Not needed for getting rssi, but for other scripts
ip addr add "$IP/24" dev wlan0

# Separate error handling
set +e

# check RSSI level
while true; do
	SIGNAL="$(iw dev wlan0 link | grep "signal")"
	if [ "$SIGNAL" != "" ]; then
		echo "$SIGNAL"
		exit 0
	elif [ "$ATTEMPT" -eq "0" ]; then
			echo "Error: cannot get wlan signal"
			exit 1
	else
		usleep 500000
		ATTEMPT="$((ATTEMPT - 1))"
	fi
done
