#!/bin/sh
set -eu

. /usr/share/nsdk/settings-migration/common-functions

OLD_SETTING="$RW_SETTINGS_DIR/system/activeAssistant"
NEW_SETTING="$RW_SETTINGS_DIR/machine/activeAssistant"
NEW_SETTING_DIR="$(dirname $NEW_SETTING)"

if [ -e "$OLD_SETTING" ]; then
	debug "Migrating activeAssistant setting"

	# Make sure the target directory exists
	if [ ! -d "$NEW_SETTING_DIR" ]; then
		mkdir -p "$NEW_SETTING_DIR"
	fi

	# Get current assistant and convert it to feature name
	ASSISTANT_NAME=$(_jq '.["value"]["string_"]' "$OLD_SETTING")
	ASSISTANT=""
	if [ "$ASSISTANT_NAME" = "Google Voice Assistant" ]; then
		ASSISTANT="googlecast"
	elif [ "$ASSISTANT_NAME" = "Alexa Voice Service" ]; then
		ASSISTANT="alexavoiceservice"
	elif [ "$ASSISTANT_NAME" = "Tencent Voice Service - Xiaowei" ]; then
		ASSISTANT="tencentxiaowei"
	elif [ "$ASSISTANT_NAME" = "Tencent Voice Service - DingDang" ]; then
		ASSISTANT="tencentdingdang"
	else
		error "Unknown assistant: '$ASSISTANT_NAME', migration failed"
	fi

	_jq ".[\"value\"][\"string_\"] = \"$ASSISTANT\"" "$OLD_SETTING" > "$NEW_SETTING"

	rm "$OLD_SETTING"
fi
