<!DOCTYPE html>
<html>
	<head>
		<meta content="text/html;charset=utf-8" http-equiv="Content-Type">

		<title>StreamSDK Device Settings</title>
		<link rel="stylesheet" type="text/css" href="/style/style.css">
		<link rel="stylesheet" type="text/css" href="/style/jquery-ui.min.css">

		<script type="text/javascript" src="/jsapi/jquery.min.js"></script>
		<script type="text/javascript" src="/jsapi/jquery-ui.min.js"></script>
		<script type="text/javascript" src="/jsapi/nsdk-api.js"></script>
		<script type="text/javascript" src="/jsapi/common.js"></script>
		<script type="text/javascript" src="/scripts/menu.js.fcgi"></script>

		<script type="text/javascript">
			var factoryResetTimer;

			function submitDeviceName() {
				var newDeviceName = document.getElementById("deviceNameDynamic").value;
				NSDK_SetData("settings:/deviceName", newDeviceName, "value").always(function() {
					loadDeviceName($('#deviceNameDynamic'), $('#airplayDeviceNameLabel'));
					alert("Device name was changed successfully");
				});
			}

			function submitAirplayPassword() {
				var password = $('#airplayPasswordDynamic').val();
				NSDK_Activate("airplay:setPassword", password)
					.done(function() {
					alert("AirPlay password was changed successfully");
				})
				.fail(function() {
					alert("AirPlay password could not be updated");
				});
			}

			function isFilenameValid(filename) {
				return filename != "";
			}

			function formFilenameValidator() {
				var obj = $('#deviceFirmwareDynamic');
				var valid = isFilenameValid(obj.val());
				if (valid) {
					submitFirmware();
				}
			}

			function submitFirmware() {
				var formData = new FormData();
				var file = $('#deviceFirmwareDynamic')[0].files[0];
				formData.append("datafile", file);

				$.ajax({
					type: 'POST',
					url: 'settings.fcgi?firmwareupdate=1',
					data: formData,
					cache: false,
					contentType: false,
					processData: false,
					xhr: function() {
						var myXhr = $.ajaxSettings.xhr();
						if( myXhr.upload ) {
							myXhr.upload.addEventListener('progress' , handleProgress , false);
						}
						return myXhr;
					},
					success: onSuccess,
					error: onError
				});

				function handleProgress(e)
				{
					if (e.lengthComputable) {
						var isOpen = $("#dialog").dialog("isOpen");
						if (isOpen == false) {
							$("#dialog").dialog("option", "title", "Copying firmware...");
							$("#dialog").dialog("open");
						}

						var progress = Math.round(e.loaded / e.total * 100);
						$('#firmwareProgress').progressbar("value", progress);
					}
				}

				function onSuccess()
				{
					$('#firmwareProgress').hide();
					$("#dialog").dialog("option", "title", "Updating firmware...");
					$("#dialog").html('Please wait for the device to finish updating the firmware, webpage will refresh automatically...');

					setTimeout(waitDownload, 500);
				}

				function onError()
				{
					$('#firmwareProgress').hide();
					$("#dialog").dialog("option", "title", "Firmware update failed...");
					NSDK_GetData("firmwareupdate:webErrorMessage", "value")
						.done(function(n) {
							$("#dialog").text(n.value.string_);
						});
				}
			}

			function checkForUpdate() {
				$("#checkForUpdateButton").attr("disabled", true);
				$("#checkForUpdateStatic").text("Checking for update...");

				NSDK_Activate("firmwareupdate:checkForUpdate")
					.done(function(n) {
						if (n != null) {
							if (n.forcedUpdate) {
								$("#checkForUpdateStatic").text("Version " + n.version + " available & marked as 'forced', updating...");
								$("#checkForUpdateButton").text("Downloading & installing...");

								$("#dialog").dialog("option", "title", "Force-updating device...");
								$("#dialog").html('New forced update had been found. Please wait while the device updates itself, webpage will refresh automatically...');
								$("#dialog").dialog("open");
								setTimeout(refreshPage, 60000);
							}
							else {
								$("#checkForUpdateStatic").text("Version " + n.version + " available");
								$("#checkForUpdateButton").attr("disabled", false);
								$("#checkForUpdateButton").text("Install");
								$("#checkForUpdateButton").attr("onclick", "downloadUpdate()");
							}
						}
						else {
							$("#checkForUpdateStatic").text("No new update available");
							$("#checkForUpdateButton").attr("disabled", false);
						}
					})
					.fail(function() {
						$("#checkForUpdateStatic").text("Error while checking for updates");
						$("#checkForUpdateButton").attr("disabled", false);
						$("#checkForUpdateButton").text("Check");
						$("#checkForUpdateButton").attr("onclick", "checkForUpdate()");
					});
			}

			function downloadUpdate() {
				$("#checkForUpdateButton").attr("disabled", true);
				$("#checkForUpdateStatic").text("Downloading & installing update...");

				$("#dialog").dialog("option", "title", "Updating device...");
				$("#dialog").html('Please wait while the device updates itself, webpage will refresh automatically...');
				$("#dialog").dialog("open");

				NSDK_Activate("firmwareupdate:downloadNewUpdate")
					.always(function(response) {
						setTimeout(refreshPage, 60000);
					});
			}

			function rebootToUpdateMode() {
				$("#dialog").dialog("option", "title", "Rebooting to the Update Mode...");
				$("#dialog").html('Please wait while device reboots to the Update Mode, webpage will refresh automatically...');
				$("#dialog").dialog("open");

				NSDK_Activate("firmwareupdate:startLocalUpdate")
					.done(function() {
						setTimeout(refreshPageToHostname, 15000);
					})
					.fail(function() {
						$("#dialog").html('Failed to switch to updater mode, firmware update is not idle');
					});
			}

			function waitDownload() {
				NSDK_GetData("firmwareupdate:updateStatus", "value")
					.done(function(n) {
						if (n.value.firmwareUpdateStatus.state == "downloading") {
							setTimeout(waitDownload, 500);
							return;
						}

						if (n.value.firmwareUpdateStatus.state != 'downloaded') {
							$('#firmwareProgress').hide();
							$("#dialog").html('Firmware update failed...');
							return;
						}

						var options = {"firmwareUpdateOptions" : {"forceSfupdate" : true}}
						NSDK_Activate("firmwareupdate:installUpdate", options).always(function() {
							setTimeout(refreshPage, 30000);
						});
					})
					.fail(function() {
						$('#firmwareProgress').hide();
						$("#dialog").html('Firmware update failed...');
					});
			}

			function factoryReset() {
				var r = confirm("Are you sure you want to reset the device to factory settings");
				if (r == true) {
					NSDK_Activate("systemmanager:factoryReset/initiate").always(function(response) {
						$("#dialogFactoryReset").dialog("option", "title", response.error.title);
						$("#dialogFactoryReset").html(response.error.message);
						$("#dialogFactoryReset").dialog("open");
						factoryResetTimer = setTimeout(refreshPage, 30000);
					});
				}
			}

			function downloadLogs() {
				NSDK_Activate("systemmanager:/createLogFile", {}).always(function(response) {
					if ("xclass" in response && response.xclass == "NsdkActionReply" && "result" in response && "path" in response.result) {
						var logUrl = "/file/stream/" + response.result.path;
						$("#systemLogsForm").attr("action", logUrl);
						$("#systemLogsForm").submit();
					}
					else {
						$("#dialog").dialog("option", "title", "Downloading logs...");
						$("#dialog").html('Downloading logs failed: ' + (response.error && response.error.message || "Unknown error"));
						$("#dialog").dialog("open");
					}
				});
			}

			function refreshPage() {
				$.ajax({url: window.location.href, timeout: 1000, cache: false})
					.done(function() {
						window.location.reload(true);
					})
					.fail(function() {
						setTimeout(refreshPage, 1000);
					});
			}

			function refreshPageToHostname() {
				var hostnameUrl = "//" + window.location.hostname
				$.ajax({url: hostnameUrl, timeout: 1000, cache: false})
					.done(function() {
						// in order to prevent caching, we have to do it this way :(
						window.location.href = hostnameUrl + "/?_=" + new Date().getTime();
					})
					.fail(function() {
						setTimeout(refreshPageToHostname, 1000);
					});
			}

			function handleAirPlayPairing()
			{
				NSDK_GetData("settings:/airplay/addedToHome", "value")
					.done(function(addedToHome) {

					if (addedToHome.value.bool_) {

						$('#airplayPasswordEditable').hide();
						$('#airplayPasswordReadOnly').show();
						$('#appleHomeNotice').show();
					} else {
						$('#airplayPasswordEditable').show();
						$('#airplayPasswordReadOnly').hide();
						$('#appleHomeNotice').hide();
					}
				});
			}

			function loadDeviceName(input, label)
			{
				NSDK_GetData("settings:/deviceName", "value")
					.done(function(deviceName) {

					NSDK_GetData("settings:/airplay/deviceName", "value")
						.done(function(airplayName) {

						var text;

						// update the device name (editable) field
						text = deviceName.value.string_;
						if (input)
							input.val(text);


						// if the airplay name and device names are different, put it into the "label" text field:
						if (airplayName.value.string_ && airplayName.value.string_.length && (airplayName.value.string_ != deviceName.value.string_)) {
							text = "AirPlay: " + airplayName.value.string_;
						}
						else {
							text = "";
						}

						if (label)
							label.text(text);

					});
				});
			}

			$(document).ready(function() {
				formFilenameValidator();

				$('#dialog').dialog({
					autoOpen: false
				});

				$('#firmwareProgress').progressbar();

				$('#dialogFactoryReset').dialog({
					autoOpen: false,
					close: function(event, ui) {
						factoryResetTimer && clearTimeout(factoryResetTimer);
					}
				});

				handleAirPlayPairing();
				loadDeviceName($('#deviceNameDynamic'), $('#airplayDeviceNameLabel'));

				var downloadPartitionPresent = '<?nsdk getData path="firmwareupdate:downloadPartitionPresent" roles="value" escape="js"?>'
				if (downloadPartitionPresent == "true") {
					$('#fw_local_update').show();
				} else {
					$('#fw_local_update').hide();
				}

				//Check if NsdkFirmwareUpdateStartLocalUpdatePath node is activated
				var localUpdateNode = '<?nsdk getData path="firmwareupdate:startLocalUpdate" roles="value" escape="js"?>';
				if (localUpdateNode.startsWith('[[')) {
					$('#fw_update_mode').hide();
				} else {
					$('#fw_update_mode').show();
				}

				var airplay = '<?nsdk getData path="airplay:version" roles="value" escape="js"?>';

				if (!airplay.startsWith('[[')) {
					$('#airplaySettings').show();
				}
			});
		</script>

	</head>

	<body>
		<div id="menu"></div>

		<fieldset id="settings">
			<legend>Settings</legend>

			<dl>
				<dt><label id="deviceNameStatic">Device Name</label></dt>
				<dd>
					<div>
						<label id="airplayDeviceNameLabel"/>
					</div>
					<div>
						<input id="deviceNameDynamic" type="text"/>
						<button id="deviceNameSubmit" class="submitButton" onclick="submitDeviceName()">Submit</button>
					</div>
				</dd>
			</dl>

			<div hidden id="airplaySettings">
				<dl>
					<dt><label id="airplayPasswordStatic">AirPlay Password</label></dt>
					<dd>
						<div id="airplayPasswordReadOnly" style="display: none;">
							<input disabled type="text" value="<?nsdk getData path="settings:/airplay/password" roles="value" escape="html"?>"/>
						</div>
						<div id="airplayPasswordEditable" style="display: none;">
							<input id="airplayPasswordDynamic" type="password" value=""/>
							<button id="airplayPasswordSubmit" class="submitButton" onclick="submitAirplayPassword()">Submit</button>
						</div>
					</dd>
				</dl>

				<dl>
					<dt><label id="appleHomeNotice" style="display: none;"><b>Use Apple Home to Change AirPlay Name or Password</b></dt>
				</dl>
			</div>
		</fieldset>

		<fieldset>
			<legend>Firmware Update</legend>
			<dl>
				<dt><label id="checkForUpdateStatic">Check for update</label></dt>
				<dd>
					<button id="checkForUpdateButton" class="submitButton" onclick="checkForUpdate()">Check</button>
				</dd>
			</dl>
			<dl id="fw_local_update">
				<dt><label id="deviceFirmwareStatic">File</label></dt>
				<dd>
					<input id="deviceFirmwareDynamic" type="file" onChange="formFilenameValidator()"/>
				</dd>
			</dl>
			<dl id="fw_update_mode">
				<dt><label id="deviceFirmwareStatic">Reboot device to the Update Mode</label></dt>
				<dd>
					<button id="deviceFirmwareSubmit" class="submitButton" onclick="rebootToUpdateMode()">Reboot</button>
				</dd>
			</dl>
		</fieldset>

		<fieldset id="reset">
			<legend>Factory Reset</legend>
			<dl>
				<dt><label id="factoryResetLabel">Restore your device to factory settings</label></dt>
				<dd>
					<button id="factoryResetInvoke" class="submitButton" onclick="factoryReset()">Factory reset</button>
				</dd>
			</dl>
		</fieldset>

		<fieldset id="logs">
			<legend>System logs</legend>
			<dl>
				<dt><label id="systemLogsLabel">Download system logs</label></dt>
				<dd>
					<button id="systemLogsDownload" class="submitButton" onclick="downloadLogs()">Download</button>
				</dd>
			</dl>
		</fieldset>

		<form id="systemLogsForm" style="display: none"></form>

		<div id="dialog">
			<div id="firmwareProgress"></div>
		</div>

		<div id="dialogFactoryReset"></div>
	</body>
</html>
