$(document).ready(function () {
  var zoneFixed = "#zone-2-fixed-vol";
  var volId = "#zone-2-volume";
  var maxVolId = "#zone-2-max-vol";
  var maxVolOnId = "#zone-2-max-on-vol";

  startup();

  function startup() {
    restorePreviousValues();

    $(zoneFixed).change(updateZoneVolumeControls);
    $(zoneFixed).change();

    $(volId).on("input", limitVolumeToMaxVolume);
    $(maxVolId).on("input", volumeMaxChanged);
    $(maxVolOnId).on("input", limitVolumeMaxOnToMaxVolume);

    window.socketMessageReceived = function(msg) {
      updateValuesUsing(parseZoneSettingsBuffer(msg));
      $(zoneFixed).change();
    };

    window.webSocket.send(0x2F, [0xF0]);
  }

  function parseZoneSettingsBuffer(buffer) {
    if (buffer.length != 12) {
      throw "Invalid buffer length: " + buffer.length;
    }

    if (!validateCommandCode(buffer, 0x2F)) {
      throw "Invalid command code.";
    }

    var data = buffer.slice(5, buffer.length - 1);

    return {
      "zone-2-input": data[0],
      "zone-2-status": data[1],
      "zone-2-volume": data[2],
      "zone-2-max-vol": data[3],
      "zone-2-fixed-vol": data[4],
      "zone-2-max-on-vol": data[5],
    };
  }

  window.encodeModel = function(model) {
    var data = new Array(6);
    data[0] = model["zone-2-input"];
    data[1] = model["zone-2-status"];
    data[2] = model["zone-2-volume"];
    data[3] = model["zone-2-max-vol"];
    data[4] = model["zone-2-fixed-vol"];
    data[5] = model["zone-2-max-on-vol"];
    return { code: 0x2F, data: data };
  };

  function updateZoneVolumeControls() {
    var isFixed = $("#zone-2-fixed-vol").val() == 1;
    $("#zone-2-max-on-vol, #zone-2-max-vol, #zone-2-volume, .stepper").prop("disabled", isFixed);
  }

  function volumeMaxChanged() {
    limitVolumeToMaxVolume();
    limitVolumeMaxOnToMaxVolume();
  }

  function limitVolumeToMaxVolume() {
    var vol = $(volId).val();
    var maxVol = $(maxVolId).val();

    if (vol > maxVol) {
      $(volId).val(maxVol);
    }
  }

  function limitVolumeMaxOnToMaxVolume() {
    var maxVol = $(maxVolId).val();
    var maxVolOn = $(maxVolOnId).val();

    if (maxVolOn > maxVol) {
      $(maxVolOnId).val(maxVol);
    }
  }

  window.shouldRespondToStepper = function(key, modifier) {
    var vol = "zone-2-volume";
    var maxVol = "zone-2-max-vol";
    var maxVolOn = "zone-2-max-on-vol";

    if (key === maxVol && modifier === "decrease") {
      const maxVolumeValue = $(maxVolId).val();
      if ($(volId).val() >= maxVolumeValue) {
        updateModel(vol, Number(maxVolumeValue) - 1);
      }

      if ($(maxVolOnId).val() >= maxVolumeValue) {
        updateModel(maxVolOn, Number(maxVolumeValue) - 1);
      }
    }

    if (key === vol && modifier === "increase") {
      return $(volId).val() < $(maxVolId).val();
    }

    if (key === maxVolOn && modifier === "increase") {
      return $(maxVolOnId).val() < $(maxVolId).val();
    }

    return true;
  };
});
