#!/bin/sh
#
# Calculate average RSSI from amount of SAMPLES

set -e

show_help()
{
cat << EOF
Usage:
	factory_tool test_bt <ADDRESS-OF-BT-DEVICE>

Parameters:
	ADDRESS-OF-BT-DEVICE
		DUT will create connection with this device and read
		RSSI value of this connection.
		All letters in hexadecimal valuesshould be uppercase
		and each pair should be separated by colon.
		Example: 12:34:56:AB:CD:EF
EOF
}

if [ "$1" = "help" ]; then
	show_help
	exit 0
elif [ $# -ne 1 ]; then
	show_help
	exit 1
fi

BT_ADDR="$1"
CURRENT_RSSI=
RSSI=0
SAMPLES=10

# Exit if BT_ADDR is not in correct format
if echo "$BT_ADDR" | grep -o -v "^[[:xdigit:]:]\{17\}$" > /dev/null; then
	echo "Error: wrong ADDRESS-OF-BT-DEVICE address format"
	show_help
	exit 1
fi

# Create connection
hcitool cc "$BT_ADDR"
for i in `seq "$SAMPLES"`; do
	# Ping before measuring RSSI
	l2ping -c 1 -t 3 -f "$BT_ADDR" &> /dev/null
	# Separate error handling
	set +e
	CURRENT_RSSI="$(hcitool rssi "$BT_ADDR" 2>/dev/null)"
	if [ $? -ne 0 ]; then
		echo "Error: getting RSSI value failed"
		exit 1
	fi
	set -e
	CURRENT_RSSI="$(echo "$CURRENT_RSSI" | grep -o "[-0-9]*")"
	RSSI="$((RSSI + CURRENT_RSSI))"
	usleep 50000
done
echo "Average RSSI: $((RSSI / SAMPLES))"
hcitool dc "$BT_ADDR"

exit 0
