#!/bin/sh
set -eu

. /usr/share/nsdk/settings-migration/common-functions

fileMediaSettings="$RW_SETTINGS_DIR/bluetooth/autoPlayMode"
fileSettingsDefault="$RO_SETTINGS_DIR/bluetooth/autoPlayMode"

# We check if default and device settings are using a different file format for
# autoPlayMode and then delete the settings file if it differs from the default
# settings [JBLL75MS-1604]
if [ -f "$fileMediaSettings" ] && [ -f "$fileSettingsDefault" ]; then
    # Parse the relevant fields using jq
    mediaSettingsValue=$(jq '.value.type' "$fileMediaSettings")
    settingsDefaultValue=$(jq '.value.type' "$fileSettingsDefault")

    # Compare the formats (assuming the type field is sufficient for comparison)
    if [ "$mediaSettingsValue" = '"string_"' ] && [ "$settingsDefaultValue" = '"bluetoothAutoPlayMode"' ]; then
        echo "Old format found in /media/settings, new format in /settings-default."
        # Remove the old format file
        rm "$fileMediaSettings"
        echo "/media/settings/settings/bluetooth/autoPlayMode removed."
    else
        echo "Formats do not match the expected old/new criteria."
    fi
fi
