#!/bin/sh
#
# Record audio using microphones, aux or spdif for analysis

set -e

. /usr/share/factory-tool/scripts/factory_tool_include

DURATION="$1"
SOURCE="$2"

show_help()
{
cat << EOF
Usage:
	factory_tool test_audio_input <DURATION> <SOURCE>

Parameters:
	DURATION
		Duration of recording (seconds).
	SOURCE = mics | aux | spdifin
		Source of recording. Could be microphones, AUX or SPDIF.

Notes:
	For SPDIF 2 channel uncompressed audio should be used.

EOF
}

if [ "$1" = "help" ]; then
	show_help
	exit 0
elif [ $# -ne 2 ]; then
	show_help
	exit 1
fi

case "$SOURCE" in
	mics)
		MAX_INPUT_CH="$MAX_MICS_INPUT_CH"
		;;
	aux)
		MAX_INPUT_CH="$MAX_AUX_INPUT_CH"
		;;
	spdifin)
		MAX_INPUT_CH=2
		;;
	*)
		echo "Error: wrong SOURCE parameter"
		show_help
		exit 1
		;;
esac

if [ `cat /etc/asound.conf | grep -q -i "pcm.$SOURCE"` ]; then
	echo "Error: SOURCE is not present"
	exit 1
fi

arecord -f S32_LE -r 48000 -c "$MAX_INPUT_CH" -t wav -d "$DURATION" -D "$SOURCE" /tmp/input.wav &
# if SPDIF HW isn't clocked, the process won't quit after the duration
sleep "$DURATION"
pkill -P $$

exit 0
