<!DOCTYPE html>
<html>
	<head>
		<meta content="text/html;charset=utf-8" http-equiv="Content-Type">

		<title><?nsdk getData path="settings:/system/modelName" roles="value" escape="html"?> &ndash; OAuth2 Page</title>
		<link rel="stylesheet" type="text/css" href="/style/style.css">

		<script type="text/javascript" src="/jsapi/jquery.min.js"></script>
		<script type="text/javascript" src="/jsapi/nsdk-api.js"></script>
		<script type="text/javascript" src="/jsapi/common.js"></script>
		<script type="text/javascript" src="/scripts/menu.js.fcgi"></script>

		<script type="text/javascript">
			var oauthServices = {}

			function showNA(serviceId, msg, clear)
			{
				if (clear) {
					$(serviceId +"-logout").html("");
					$(serviceId +"-login").html("");
				} else {
					$(serviceId +"-logout").hide();
					$(serviceId +"-login").hide();
				}
				$(serviceId +"-na").html("<p>" + msg + "</p>");
				$(serviceId +"-na").show();
			}

			function statusChanged(serviceId, status)
			{
				$("#" + serviceId +"-na").hide();
				$("#" + serviceId +"-logout").hide();
				$("#" + serviceId +"-login").hide();
				if (status == 'notAvailable') {
					showNA("Module is not available.", true);
				} else if (status == 'noNetwork') {
					showNA("Network is not available.", false);
				} else if (status == 'loginRequired') {
					$("#" + serviceId +"-login").show();
				} else {
					$("#" + serviceId +"-logout").show();
				}
			}

			function login(serviceId)
			{
				// Disable all login/logout buttons
				$("#oauthContent :input").prop("disabled", true)

				// Change the clicked button's text to 'Logging in'
				$("#" + serviceId + "-login :input").text("Logging in")

				// Retrieve service login data
				let serviceOauth2Info = oauthServices[serviceId].oauth2Info;
				if (serviceOauth2Info.browserAuthFlowPath) {
					let requestData = {
						"type": "string_",
						"string_": window.location.href
					};

					NSDK_Activate(serviceOauth2Info.browserAuthFlowPath, requestData)
						.done(function(data) {
							// Construct and execute the POST request
							var form = $(`<form action="${data.url}" method="post"></form>`)
							$('body').append(form)
							form.submit()
						})
						.fail(function() {
							alert("Unable to retrieve service data!")
						});
				}
				else if (serviceOauth2Info.deviceFlowPath) {
					NSDK_Activate(serviceOauth2Info.deviceFlowPath)
						.done(function(data) {
							let divLoginId = serviceId + "-login";
							$("#" + divLoginId).html(`<p>
								Please navigate to: <a href=${data.url}>${data.url}</a> <br>
								to enter the fallowing code: "${data.code}"
							</p>`);
							NSDK_Subscribe.subscribe(oauthServices[serviceId].path, "itemWithValue", function(event) {
								if (event.itemValue && event.itemValue.oauth2Info.loggedIn == true)
									location.reload();
							})
						})
						.fail(function() {
							alert("Unable to retrieve service data!")
						});
				}
				else {
					alert("Any suitable method for login!")
				}
			}

			function logout(serviceId, serviceTitle)
			{
				if (confirm(`Are you sure you want to logout from ${serviceTitle}?`)) {
					NSDK_Activate(oauthServices[serviceId].oauth2Info.logoutPath).done(function() {
						statusChanged(serviceId, 'loginRequired');
					});
				}
			}

			$(document).ready(function() {
				// This site might be invoked in two ways, first as a menu item on the webpage (the normal
				// use case), and second, at the end of the login process, where we get the encrypted
				// authorization code or an error message from our cloud. In the latter case, we expect
				// to see "code", "state" and "aesKey" query parameters in the successful case, "error", "state"
				// and possibly also "error_description" in the error case. So, if these queries are present,
				// we'll treat this invocation as the second case, otherwise as the first one.
				var currentUrl = new URL(window.location.href)
				var state = currentUrl.searchParams.get("state")

				if (state === null) {
					NSDK_GetRows("oauth2:/service", "title,path,value", 0, 100).done(function(data) {
						if (data.rowsCount > 0) {
							// We have at least one service using OAuth

							for (var i = 0; i < data.rowsCount; i++) {
								// Unique service identifier that can be used in divs (i. e. has no spaces)
								let serviceId = "service-" + i
								let serviceTitle = data.rows[i].title
								let servicePath = data.rows[i].path
								let serviceOauth2Info = data.rows[i].value.oauth2Info ? data.rows[i].value.oauth2Info : {};

								oauthServices[serviceId] = {
									"title": serviceTitle,
									"path": servicePath,
									"oauth2Info": serviceOauth2Info
								}

								let divNotAvailableId = serviceId + "-na"
								let divLoginId = serviceId + "-login"
								let divLogoutId = serviceId + "-logout"

								// Generate entry for each OAuth service
								$("#oauthContent").append(`
									<fieldset id="${serviceId}">
										<legend>${serviceTitle}</legend>
										<div id="${divNotAvailableId}" style="display: none"></div>
										<div id="${divLoginId}" style="display: none">
											<p>Click on the button below to login or register.</p>
											<button id="link" type="button" name="linkButton" onclick="login('${serviceId}')">Login</button>
										</div>
										<div id="${divLogoutId}" style="display: none">
											<p>You are already logged in.</p>
											<p>If you want to unlink the device from your account click the button below.</p>
											<button type="button" id="unlink" name="unlinkButton" onclick="logout('${serviceId}', '${serviceTitle}')">Logout</button>
										</div>
									</fieldset>
								`)

								if (serviceOauth2Info.loggedIn === true) {
									statusChanged(serviceId, 'login');
								}
								else {
									statusChanged(serviceId, 'loginRequired');
								}
							}
						}
						else {
							// No services use OAuth
							$("#oauthContent").html("<p>There are no services using OAuth2 authentication on this build</p>")
						}

					}).fail(function() {
						alert("Unable to get OAuth service information")
					});
				}
				else {
					var authCode = currentUrl.searchParams.get("code")
					var error = currentUrl.searchParams.get("error")

					if (authCode !== null) {
						var aesKey = currentUrl.searchParams.get("aesKey")
						var servicePath = currentUrl.searchParams.get("servicePath")

						// Sanity check
						if (aesKey === null || servicePath === null) {
							alert("Code is present, but aesKey or servicePath are not!")
							return
						}

						var oauth2Code = {
							"type": "oauth2AuthResponse",
							"oauth2AuthResponse": {
								"encryptedCode": authCode,
								"state": state,
								"aesKey": aesKey,
							}
						}

						$('#oauthContent').html("<p>Logging in...</p>")

						NSDK_SetData(servicePath, oauth2Code, "value")
							.done(function() {
								// Reload the current page on OK, but without query params
								$('#oauthContent').html(`
									<fieldset>
										<legend>Login Status</legend>
										<p>Login was successful!</p>
										<p><a href='oauth.fcgi'>OK</a></p>
									</fieldset>
								`);
							})
							.fail(function(e) {
								$('#oauthContent').html(`
									<fieldset>
										<legend>Login Status</legend>
										<p>Login failed: ${e.error.message}</p>
										<p><a href='oauth.fcgi'>OK</a></p>
									</fieldset>
								`);
							})
					}
					else if (error !== null) {
						var errorToPrint = error

						var errorDescription = currentUrl.searchParams.get("error_description")
						if (errorDescription !== null) {
							errorToPrint += ", "
							errorToPrint += errorDescription
						}
						$('#oauthContent').html(`
							<fieldset>
								<legend>Login Status</legend>
								<p>Login failed: ${errorToPrint}</p>
								<p><a href='oauth.fcgi'>OK</a></p>
							</fieldset>
						`)
					}
				}

			});

		</script>
	</head>

	<body>
		<div id="menu"></div>
		<div id="oauthContent"></div>
	</body>
</html>
