<!DOCTYPE html>
<html>
	<head>
		<meta content="text/html;charset=utf-8" http-equiv="Content-Type">

		<title><?nsdk getData path="settings:/system/modelName" roles="value" escape="html"?> &ndash; Main Page</title>
		<link rel="stylesheet" type="text/css" href="/style/style.css">
		<link rel="stylesheet" type="text/css" href="/style/jquery-ui.min.css">

		<script type="text/javascript" src="/jsapi/jquery.min.js"></script>
		<script type="text/javascript" src="/jsapi/jquery-ui.min.js"></script>
		<script type="text/javascript" src="/jsapi/nsdk-api.js"></script>
		<script type="text/javascript" src="/jsapi/common.js"></script>
		<script type="text/javascript" src="/scripts/menu.js.fcgi"></script>

		<script type="text/javascript">
			function buttonBugReportSubmit() {
				var valid = true;
				var title = $('#inputBugReportTitle').val().trim();
				if (!title) {
					valid = false;
					$('#inputBugReportTitleError').show();
				}

				var description = $('#textareaBugReportDescription').val().trim();
				if (!description) {
					valid = false;
					$('#textareaBugReportDescriptionError').show();
				}

				if (valid) {
					$("#dialog").dialog("option", "title", "Uploading report...");
					$("#dialog").text("");
					$("#dialog").dialog("open");
					NSDK_Activate("reporting:makeUserReport", {"title" : title, "description" : description})
						.done(function() {
							$("#dialog").dialog("option", "title", "Upload finished...");
							$("#dialog").text("Report sent");
						})
						.fail(function(response) {
							$("#dialog").dialog("option", "title", "Upload failed...");
							$("#dialog").text("Failed to upload report: " + (response.error && response.error.message || "Unknown error"));
						});
				}
			}

			$(document).ready(function() {
				$('#dialog').dialog({
					autoOpen: false
				});

				$('#inputBugReportTitle').on('input', function() {
					$('#inputBugReportTitleError').hide();
				});

				$('#textareaBugReportDescription').keyup(function(event) {
					$('#textareaBugReportDescriptionError').hide();
				});
			});

		</script>

	</head>

	<body>
		<div id="menu"></div>

		<fieldset id="bugReport">
			<legend>Bug report</legend>
			<dl>
				<dt><label>Title:</label></dt>
				<dd id=inputBugReportTitleError hidden style="color:red;">Title is empty</dd>				
				<dd><input id="inputBugReportTitle" type="text"/></dd>
			</dl>
			<dl>
				<dt><label>Description:</label></dt>
				<dd id=textareaBugReportDescriptionError hidden style="color:red;">Description is empty</dd>	
				<dd><textarea id="textareaBugReportDescription" cols="40" rows="5"></textarea></dd>
			</dl>
			<button type="button" onclick="buttonBugReportSubmit()">Submit</button><br>
		</fieldset>

		<div id="dialog"></div>
	</body>
</html>
