$(document).ready(function () {
  startup();

  function startup() {
    restorePreviousValues();

    var cec = "#cec-control";
    $(cec).change(updateCECOptions);

    window.socketMessageReceived = function(msg) {
      updateValuesUsing(parseHDMISettingsBuffer(msg));
      $(cec).change();
    };

    window.webSocket.send(0x2E, [0xF0]);
  }

  function parseHDMISettingsBuffer(buffer) {
    if (buffer.length != 16) {
      throw "Invalid buffer length: " + buffer.length;
    }

    if (!validateCommandCode(buffer, 0x2E)) {
      throw "Invalid command code.";
    }

    var data = buffer.slice(5, buffer.length - 1);

    return {
      "zone-1-osd": data[0],
      "zone-1-out": data[1],
      "zone-1-lip-sync": data[2] + " ms",
      "hdmi-audio-to-tv": data[3],
      "hdmi-bypass-ip": data[4],
      "hdmi-bypass-source": data[5],
      "cec-control": data[6],
      "arc-control": data[7],
      "tv-audio": data[8],
      "power-off-control": data[9]
    };
  }

  window.encodeModel = function(model) {
    var data = new Array(10);
    data[0] = model["zone-1-osd"];
    data[1] = model["zone-1-out"];
    data[2] = 0;
    data[3] = model["hdmi-audio-to-tv"];
    data[4] = model["hdmi-bypass-ip"];
    data[5] = model["hdmi-bypass-source"];
    data[6] = model["cec-control"];
    data[7] = model["arc-control"];
    data[8] = model["tv-audio"];
    data[9] = model["power-off-control"];
    return { code: 0x2E, data: data };
  };

  function updateCECOptions() {
    var isCECDisabled = $("#cec-control :selected").val() == 0;

    // If CEC is enabled, enable eARC control, TV audio and power off control
    $("#arc-control, #tv-audio, #power-off-control").prop("disabled", isCECDisabled);

    // If CEC is set to output 1, disable HDMI audio to tv, HDMI bypass IP and HDMI bypass source.
    $("#hdmi-audio-to-tv, #hdmi-bypass-ip, #hdmi-bypass-source").prop("disabled", !isCECDisabled);
  }
});
