#!/bin/sh
set -eu

# load common functions first
. /usr/share/nsdk/settings-migration/common-functions

LAST_BOOTED_VERSION=`get_settings_value "versionLastBooted" | _jq '.value.string_'`
NOW_BOOTED_VERSION=`get_settings_value "version" | _jq '.value.string_'`

# Determine whether the migration scripts have to be run. This might save us
# from doing some processing on each boot. We run the scripts only if the version
# changes, i. e. LAST_BOOTED_VERSION != NOW_BOOTED_VERSION.
# Note: after FDR, LAST_BOOTED_VERSION is empty, so we would get a false positive.
# Work around it by checking if the LAST_BOOTED_VERSION is not empty first.
if [ -n "$LAST_BOOTED_VERSION" -a "$LAST_BOOTED_VERSION" != "$NOW_BOOTED_VERSION" ]; then
	debug "Starting settings migration after update from $LAST_BOOTED_VERSION -> $NOW_BOOTED_VERSION"

	# run migration scripts
	for MIGRATION_SCRIPT in /usr/share/nsdk/settings-migration/*.sh; do
		if ! $MIGRATION_SCRIPT; then
			error "Migration script $MIGRATION_SCRIPT encountered an error"
		fi
	done
else
	debug "Settings migration is not necessary"
fi
