#!/bin/sh
#
# Set model using `fw_setconst product_postfix`

set -e

# Usage info
show_help()
{
cat << EOF
Usage:
	factory_tool set_product_postfix <MODEL>

Parameters:
	MODEL
		A model name/string to match postfix on settings in /settings-default/.
		Set to empty string to delete the model and fallback to the default.

Example:
	factory_tool set_product_postfix "foospeaker"
	factory_tool set_product_postfix ""
EOF
}


if [ "$1" = "help" ]; then
	show_help
	exit 0
elif [ $# -ne 1 ]; then
	echo "Error: wrong amount of parameters"
	show_help
	exit 1
fi

VALUE="$1"

fw_setconst product_postfix "$VALUE"

