<!DOCTYPE html>
<html>
	<head>
		<meta content="text/html;charset=utf-8" http-equiv="Content-Type">

		<title>StreamSDK Google Cast</title>
		<link rel="stylesheet" type="text/css" href="/style/style.css">

		<script type="text/javascript" src="/jsapi/jquery.min.js"></script>
		<script type="text/javascript" src="/jsapi/nsdk-api.js"></script>
		<script type="text/javascript" src="/jsapi/common.js"></script>
		<script type="text/javascript" src="/scripts/menu.js.fcgi"></script>

		<script type="text/javascript">
			var references =  {
				"iOS": {
					"DeezerApp": "https://itunes.apple.com/app/id292738169",
					"SpotifyApp": "https://itunes.apple.com/app/id324684580",
					"TuneInApp": "https://itunes.apple.com/app/id418987775",
					"GooglePlayMusic": "https://itunes.apple.com/app/id691797987"
				},
				"Android": {
					"DeezerApp": "https://play.google.com/store/apps/details?id=deezer.android.app",
					"SpotifyApp": "https://play.google.com/store/apps/details?id=com.spotify.music",
					"TuneInApp": "https://play.google.com/store/apps/details?id=tunein.player",
					"GooglePlayMusic": "https://play.google.com/store/apps/details?id=com.google.android.music"
				},
				"other": {
					"DeezerApp": "http://www.deezer.com/",
					"SpotifyApp": "http://www.spotify.com/",
					"TuneInApp": "http://tunein.com/",
					"GooglePlayMusic": "https://play.google.com/music/"
				}
			};

			function isiOSDevice() {
				return (/(iPod|iPhone|iPad)/gi).test(navigator.userAgent);
			};

			function isAndroidDevice() {
				return (/(Android)/gi).test(navigator.userAgent);
			};

			$(document).ready(function() {
				var $usageDataEnabled = '<?nsdk getData path="settings:/googleCastLite/usageReport" roles="value" escape="js"?>'
				var $tosAccepted = '<?nsdk getData path="settings:/googleCastLite/tosAccepted" roles="value" escape="js"?>'

				$('a[href^="reference://"]').each( function() {
					var $a = $(this);
					var ref = $a.attr("href").slice("reference://".length);

					if (isiOSDevice()) {
						$a.attr("href", references.iOS[ref]);
					} else if (isAndroidDevice()) {
						$a.attr("href", references.Android[ref]);
					} else {
						$a.attr("href", references.other[ref]);
					}
				});

				$('input:checkbox[name=usageData]').prop('checked', $usageDataEnabled == 'true');

				if ($tosAccepted == 'true') {
					$('p#acceptFalse').hide();
					$("button#accept").hide();
				} else {
					$('p#acceptTrue').hide();
				}
			});

			function submitTosForm() {
				var data = {};
				data["bool_"] = true;
				data["type"] = "bool_";
				NSDK_SetData("settings:/googleCastLite/tosAccepted", data).always(function() {
					location.reload();
				});
			}

		</script>
	</head>

	<body>
		<a href="/"><img src="/style/images/streamunlimited_logo.png" alt="StreamUnlimited"></a>
		<div id="menu"></div>

		<fieldset id="tos">
			<legend>Term of services</legend>

			<p>The <a href="http://www.google.com/intl/en/policies/privacy/">Google Privacy Policy</a> describes the information that Google collects
			during your set-up and use of Google Cast. You can modify your device’s Google Cast privacy settings, such as whether it sends usage data
			and crash reports to Google, after you have set up your device by accessing the device settings in this application.</p>

			<p id="acceptFalse">By pressing "Accept" below, you acknowledge that you agree to the <a href="http://www.google.com/intl/en/policies/terms/">
			Google Terms of Service</a> and <a href="http://www.google.com/intl/en/policies/privacy/ ">Google Privacy Policy</a>.</p>

			<p id="acceptTrue"><a href="http://www.google.com/intl/en/policies/terms/">Google Terms of Service</a> and
			<a href="http://www.google.com/intl/en/policies/privacy/ ">Google Privacy Policy</a> was already accepted.</p>

			<button type="button" id="accept" name="tosAcceptedButton" onclick="submitTosForm()">Accept</button><br>
		</fieldset>

		<fieldset id="about_google_cast">
			<legend>About Google Cast</legend>
			<dl>
				<dt><label class="shareUsageData">Send Google Cast usage data and crash reports to Google</label></dt>
				<dd>
					<input type="checkbox" name="usageData" disabled="disabled" value="1"> Share usage data<br>
				</dd>
			</dl>
			<dl>
				<dt><label class="enable_apps">Google Cast-enabled apps:</label></dt>
				<dd>
					<a href="reference://DeezerApp">Deezer</a><br/>
					<a href="reference://TuneInApp">TuneIn</a><br/>
					<a href="reference://GooglePlayMusic">GooglePlayMusic</a><br/>
					<a href="https://www.google.com/cast/apps/">Find more apps</a><br/>
				</dd>
			</dl>
			<dl>
				<dt><label class="version_number">Google Cast version number:</label></dt>
				<dd>
					<?nsdk getData path="settings:/googleCastLite/castVersion" roles="value" escape="html"?>
				</dd>
			</dl>
			<a href="https://www.google.com/cast/audio/learn/">Learn how to Cast</a><br>
			<a href="https://support.google.com/googlecast/answer/6076570/">Learn about Google Cast privacy</a><br>
			<a href="https://www.google.com/cast/learn/audio/#multiroom">Learn about cast groups</a><br>
			<a href="https://support.google.com/googlecast/answer/6121012">Open source licenses</a>
		</fieldset>
	</body>
</html>
