/******************************************************************************/
/* Avoid `console` errors in browsers that lack a console. */

(function() {
	var noop = function() {};
	var methods = [
		'assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error',
		'exception', 'group', 'groupCollapsed', 'groupEnd', 'info', 'log',
		'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd',
		'timeStamp', 'trace', 'warn'
	];
	var length = methods.length;
	var console = (window.console = window.console || {});

	while (length--) {
		var method = methods[length];

		// Only stub undefined methods.
		if (!console[method]) {
			console[method] = noop;
		}
	}
}());

/******************************************************************************/
/* startsWith polyfil & endsWith polyfil */

if (!String.prototype.startsWith) {
	Object.defineProperty(String.prototype, 'startsWith', {
		value: function(search, rawPos) {
			var pos = rawPos > 0 ? rawPos | 0 : 0;
			return this.substring(pos, pos + search.length) === search;
		}
	});
}

if (!String.prototype.endsWith) {
	String.prototype.endsWith = function(search, this_len) {
		if (this_len === undefined || this_len > this.length) {
			this_len = this.length;
		}
		return this.substring(this_len - search.length, this_len) === search;
	};
}

/******************************************************************************/
/* Debug */

/* alert on js error */
window.onerror = function(msg, url, line) {
	alert('Error: "' + msg + '" at Line ' + line + '\n\nUrl: "' + url + '"');
	return true;
};

function isLocalhostMode() {
	return (document.URL.search("http://localhost") === 0 || document.URL.search("file:/") === 0);
}

/* add debug class to body on localhost */
$(document).ready(function() {
	if (isLocalhostMode()) {
		$("body").addClass("debug");
	}
});

/******************************************************************************/
/* jQuery Scroll Plugin (http://stackoverflow.com/a/18647696/2133407) */

function getRealWidth($obj) {
	var $clone = $obj.clone();
	$clone.css("visibility", "hidden");
	$("body").append($clone);
	var width = $clone.outerWidth();
	$clone.remove();
	return width;
}

function boScrollHTOHInstaller($obj) {
	var boxWidth = $obj.width();
	var textWidth = getRealWidth($obj);
	if (textWidth > boxWidth) {
		// instal mouseenter/mouseleave handlers only if width is greater than box width
		// after install, first tap on touch device will cause mouseenter and the second will cause click
		$obj.bind("mouseenter", function() {
			var animSpeed = textWidth * 10;
			$(this).stop().animate({
				scrollLeft: (textWidth - boxWidth)
			}, animSpeed, function() {
				$(this).animate({
					scrollLeft: 0
				}, animSpeed, function() {
					$(this).trigger('mouseenter');
				});
			});
		}).bind("mouseleave", function() {
			var animSpeed = $(this).scrollLeft() * 10;
			$(this).stop().animate({
				scrollLeft: 0
			}, animSpeed);
			return false;
		});

	};
}

function boScrollHTOHInstallerUninstall($obj) {
	$obj.unbind("mouseenter mouseleave");
}

$.fn.boScrollHiddenTxtOnHover_Install = function() {
	return this.each(function() {
		var el = $(this);
		boScrollHTOHInstaller(el);
	});
};

$.fn.boScrollHiddenTxtOnHover_Uninstall = function() {
	return this.each(function() {
		var el = $(this);
		boScrollHTOHInstallerUninstall(el);
	});
};

/******************************************************************************/
/* Only Numbers check for  plugin */

function isKeySuitableForIntegerInput(evt) // inspired by : http://stackoverflow.com/a/16692800
{
	var key = evt.which;
	// SOME OPTIONS LIKE ENTER, BACKSPACE, HOME, END, ARROWS, -, ETC.
	var arrayExceptions = [8, 13, 16, 17, 18, 20, 27, 45, 144];
	if ((key < 48 || key > 57) && $.inArray(key, arrayExceptions) === -1) {
		return false;
	} else {
		return true;
	}
}

/******************************************************************************/
/* Object Tools */

/**
 * Returns diff object which is sparse and contain only properties from now which are different or not present in prev
 *
 * @param {object} prev Origin object
 * @param {object} now New object
 * @returns {object|false} Diff object
 */
function getChanges(prev, now) // inspired from: http://stackoverflow.com/a/11022327
{
	// sanity checks, now and prev must be an objects
	if (typeof now !== "object")
		now = {};
	if (typeof prev !== "object")
		return now;

	var changes = {};
	for (var prop in now) {
		// if prop is new in now, add it to changes
		if (!prev || !prev.hasOwnProperty(prop)) {
			changes[prop] = now[prop];
			continue;
		}
		// if prop has another type or value (different object or literal)
		if (prev[prop] !== now[prop]) {
			if (typeof now[prop] === "object") {
				// prop is an object, do recursion
				var c = getChanges(prev[prop], now[prop]);
				if (!$.isEmptyObject(c))
					changes[prop] = c;
			} else {
				// now[prop] has different but literal value
				changes[prop] = now[prop];
			}
		}
	}

	// returns empty object on none change
	return changes;
}

/**
 * Safely access the subproperty of an object
 * example:
 *	 getSubProperty(obj, "prop1.prop2.prop3")
 *	 will return obj.prop1.prop2.prop3 if such nested proprties exists
 *	 otherwise will return undefined
 * @param {object} obj
 * @param {string} path separated chain of nested property
 * @returns {mixed|undefined}
 */
function getSubProperty(obj, path) {
	var attrs = path.split("."),
		node = obj,
		undefined;
	for (var i = 0; i < attrs.length; i++) {
		if (node.hasOwnProperty(attrs[i])) {
			node = node[attrs[i]];
		} else {
			return undefined;
		}
	}
	return node;
}

/**
 * Returns true if getSubProperty(obj, path) returns defined value
 *
 * @param {object} obj Object
 * @param {string} path dot separated path of nested property
 * @returns {Boolean} true if property is defined, false otherwise
 */
function hasSubProperty(obj, path) {
	return typeof(getSubProperty()) !== 'undefined';
}

/******************************************************************************/
/* Screen Detection (ported from OldPages) */

function getScreenMedia() {
	var MODE_IPHONE = "iPhone";
	var MODE_IPOD = "iPod";
	var MODE_IPAD = "iPad";
	var MODE_HTC = "HTC";
	var MODE_ANDROID = "Android";
	var MODE_SAFARI = "Safari";
	var MODE_MOBILE_SAFARI = "Mobile Safari";
	var MODE_MOBILE = "Mobile";
	var MODE_TABLET = "Tablet";
	var MODE_IEMOBILE = "IEMobile";
	var MODE_WINDOWSPHONE = "Windows Phone";

	if (navigator.userAgent.indexOf(MODE_IPHONE) > 0 || navigator.userAgent.indexOf(MODE_IEMOBILE) > 0 || navigator.userAgent.indexOf(MODE_WINDOWSPHONE) > 0 || navigator.userAgent.indexOf(MODE_IPOD) > 0 || navigator.userAgent.indexOf(MODE_MOBILE_SAFARI) > 0 || navigator.userAgent.indexOf(MODE_HTC) > 0 || ((navigator.userAgent.indexOf(MODE_ANDROID) > 0) && (navigator.userAgent.indexOf(MODE_MOBILE) > 0))) {
		return "Mobile";
	} else if (((navigator.userAgent.indexOf(MODE_IPAD) > 0) || (navigator.userAgent.indexOf(MODE_TABLET) > 0)) || ((navigator.userAgent.indexOf(MODE_ANDROID) > 0) && (navigator.userAgent.indexOf(MODE_SAFARI) > 0))) {
		return "iPad";
	} else {
		return "";
	}
}

function IsMobile() {
	return (getScreenMedia() == "Mobile");
}

function IsPad() {
	return (getScreenMedia() == "iPad");
}

/******************************************************************************/
/* Tools */

/* older browsers does not have defined trim operation for string. e.g. IE<9.0 */
if (!String.prototype.trim) {
	String.prototype.trim = function() {
		return this.replace(/^\s*((?:[\S\s]*\S)?)\s*$/, "");
	};
}

function generateRandomElementId() {
	// Math.random should be unique because of its seeding algorithm.
	// Convert it to base 36 (numbers + letters), and grab the first 9 characters
	// after the decimal.
	return '_' + Math.random().toString(36).substr(2, 9);
}

/******************************************************************************/
/* apply iPhoneView/PCView and mobileDevice/desktopDevice class on body */

$(document).ready(function() {

	/* detect screen type, apply respective class to the body for proper page styling */
	function setPageViewType(width) {
		var iPhoneMode = (width < 576) || IsMobile();
		if (iPhoneMode) $("body").addClass("iPhoneView").removeClass("PCView");
		else $("body").addClass("PCView").removeClass("iPhoneView");
	}

	/* detect client type */
	function setDeviceType() {
		if (IsMobile() || IsPad()) $("body").addClass("mobileDevice");
		else $("body").addClass("desktopDevice");
	}

	/* on start */
	setPageViewType($(top.window).width());
	setDeviceType();

	/* on any resize */
	$(window).resize(function() {
		setPageViewType($(top.window).width());
	});
});

/******************************************************************************/
/* fix for: "Fonts become bold when changing orientation" on iOS Safari
 * this implements workaround: http://stackoverflow.com/a/7783702/2133407
 * but because of this side effect: css z-index lost after webkit transform translate3d - http://stackoverflow.com/questions/5472802/
 * this implementaion applies translate3d only on one element created by js, which is enough to trigger acceleration on whole page
 */

$(document).ready(function() {
	var $div = $("<div>");
	$div.addClass("auxElementTurning3DAcceleration");
	$("body").append($div);
});

/******************************************************************************/
/* Escaping functions */

function attr_encode(str) // percentage encoding of URI chars and also ' and " chars. useful e.g to store something in a data-* attribute
{
	str = encodeURIComponent(str); // percentage encoding
	str = str.replace('"', '%22'); // percentage encoding
	str = str.replace("'", '%27'); // percentage encoding
	return str;
}

function attr_decode(str) // opposite to attr_encode
{
	str = decodeURIComponent(str); // percentage decoding
	return str;
}

function escape_html(str) // escapes HTML chars like < and > to HTML entities (&lt; and &gt;)
{
	return $('<div/>').text(str).html();
}

function strip_html(str) // returns text without HTML tags
{
	return $('<div/>').html(str).text();
}

function textToHtml(str) {
	str = $('<div/>').text(str).html();
	str = str.replace(/"/g, "&quot;");
	str = str.replace(/'/g, "&#039;");
	return str;
}


/******************************************************************************/
/* Some commonly used functions using NSDK  */

function isSpotyfiAccountConnectedAsync() {
	var SPOTIFY_NOT_CONNECTED = "";

	var ret = jQuery.Deferred();
	NSDK_GetData("settings:/spotify/username", "value").always(function(response) {
		if (typeof(response) !== 'undefined' && typeof(response.value) !== 'undefined') {
			var value = NSDK_GetTypedValue(response.value);
			var connected = (value !== SPOTIFY_NOT_CONNECTED);
			ret.resolve(connected);
		} else {
			ret.resolve(false);
		}
	});

	return ret;
}

/**
 * Returns sw version in the Device assynchronously using jQuery.Deferred
 * @returns {Deferred} always resolve: null or string
 */
function getDeviceSWVersionAsync() {
	var ret = jQuery.Deferred();

	NSDK_GetData("settings:/version", "value").always(function(response) {
		if (typeof(response) !== 'undefined' && typeof(response.value) !== 'undefined') {
			var ver = NSDK_GetTypedValue(response.value);
			ret.resolve(ver);
		} else {
			ret.resolve(null);
		}
	});

	return ret;
}

function getSwDownloadPercentage(firmwareDownloadState) {
	if (firmwareDownloadState &&
		firmwareDownloadState.status &&
		firmwareDownloadState.status == "downloading") {
		var downloaded = firmwareDownloadState.downloadedSize;
		var size = firmwareDownloadState.totalSize;
		if (typeof(downloaded) !== 'undefined' && typeof(size) !== 'undefined') {
			downloaded = parseInt(downloaded);
			size = parseInt(size);
			if (downloaded <= size) {
				return parseInt(downloaded * 100 / size);
			}
		}
	}
	return null;
}

function getPortalSwDownloadPercentage(stateStr) {
	try {
		var state = $.parseJSON(stateStr);
		return getSwDownloadPercentage(state.firmwareDownloadState);
	} catch (e) {
		return null;
	}
}

function getPortalSwDownloadPercentageAsync() {
	var ret = $.Deferred();

	NSDK_GetData("firmwareupdate:downloader/state", "value").always(function(response) {
		if (response && response["value"]) {
			var result = getSwDownloadPercentage(response["value"].firmwareDownloadState);
			ret.resolve(result);
		} else {
			ret.resolve(null);
		}
	});

	return ret;
}

/******************************************************************************/
/* access to MainService instance */

/**
 * @returns {MainService} MainService singleton instance
 */
function getMainService() {
	if (typeof(top.mainService) === 'undefined') {
		alert("mainService is not available: " + typeof(top.mainService));
		return null;
	}

	return top.mainService;
}
