class Socket {
  constructor(address) {
    this.address = address;
    this.queuedMessages = [];
    this.socketMessageReceived = false;
    this.socketClosedManually = false;
    console.log("Constructed: " + this.address);
  }

  connect() {
    try {
      this.webSocket = new WebSocket(this.address);
      this.webSocket.binaryType = "arraybuffer";
      const $this = this;
      this.webSocket.onopen = function() {
        console.log("Socket opened");
        socket.socketClosedManually = false;
        socket.openCallback();
        setInterval(function() {
          $this.sendNextMessage();
        }, 200);
      };

      var socket = this;

      this.webSocket.onmessage = function(msg) {
        if (msg.data instanceof ArrayBuffer) {
          socket.socketMessageReceived = true;
          var buffer = new Uint8Array(msg.data);
          console.log("[Rx]: " + bufferToHex(buffer));
          socket.callback(buffer);
        }
      };

      this.webSocket.onclose = function() {
        console.log("Socket closed");
        if (!socket.socketClosedManually) {
          socket.closeCallback(true);
        }
      };

      setTimeout(socket.test, 3000);
    } catch(exception) {
      console.log("Unable to connect to " + this.address + ": " + exception);
    }
  }

  disconnect() {
    this.webSocket.socketClosedManually = true;
    this.webSocket.webSocket.close();
  }

  setCallback(func) {
    this.callback = func;
  }

  send(commandCode, data) {
    const dl = data.length;
    var wrapper = [0x21, 0x01, commandCode, dl, 0x0D];
    wrapper.splice(4, 0, ...data.map(Number));
    this.sendRaw(wrapper);
  }

  sendRaw(bytes) {
    var buffer = new Uint8Array(bytes);
    this.queuedMessages.push(buffer);
  }

  sendNextMessage() {
    const buffer = this.queuedMessages.shift();

    if (buffer == null) {
      //console.log("No pending messages");
      return;
    }

    try {
      console.log("[Tx]: " + bufferToHex(buffer));
      this.webSocket.send(buffer, { binary: true });
    } catch(exception) {
      console.log("Unable to send data: " + exception);
    }
  }
}
