#!/bin/bash
# script for generating enc_key for const partition

usage() {
	echo "Usage:"
	echo "  $0 <path_to_images>"
}

if [ $# -ne 1 ]; then
	echo "Error: invalid number of parameters!"
	usage
	exit 1
fi

DEPLOY_DIR_IMAGE="$1"

if [ ! -f "${DEPLOY_DIR_IMAGE}/swu_keys/wrap_key" ] || [ ! -f "${DEPLOY_DIR_IMAGE}/swu_keys/enc_key" ]; then
	echo "Missing wrap_key or enc_key"
	exit 1
fi

WRAP_KEY=$(grep "^key *= *" "${DEPLOY_DIR_IMAGE}/swu_keys/wrap_key" | sed 's/^key *= *//')
WRAP_HMAC=$(grep "^hmac *= *" "${DEPLOY_DIR_IMAGE}/swu_keys/wrap_key" | sed 's/^hmac *= *//')
if [ ${#WRAP_KEY} -ne 64 ] || [ ${#WRAP_HMAC} -ne 32 ]; then
	echo "Invalid wrap_key format"
	exit 1
fi

AES_KEY=$(grep "^key *= *" "${DEPLOY_DIR_IMAGE}/swu_keys/enc_key" | sed 's/^key *= *//')
AES_IV=$(grep "^iv *= *" "${DEPLOY_DIR_IMAGE}/swu_keys/enc_key" | sed 's/^iv *= *//')

if [ -z "${AES_KEY}" ] || [ -z "${AES_IV}" ]; then
	echo "Invalid aes key file format"
	exit 1
fi


TMP_DIR=`mktemp -d -t`
trap "rm -rf $TMP_DIR; exit" SIGHUP SIGINT SIGTERM EXIT

# generate IV
dd if=/dev/urandom bs=1 count=16 of="${TMP_DIR}/iv.bin" 2> /dev/null
IV=$(cat "${TMP_DIR}/iv.bin" | hexdump -v -e '/1 "%02X"')

echo -n "$AES_KEY $AES_IV" | openssl enc -e -aes-256-cbc -K $WRAP_KEY -iv $IV -nosalt -out "${TMP_DIR}/enc.bin"
echo -n "enc_key: "; cat "${TMP_DIR}/iv.bin" "${TMP_DIR}/enc.bin" | openssl dgst -sha256 -mac HMAC -macopt hexkey:$WRAP_HMAC -binary -out "${TMP_DIR}/hmac.bin"
cat "${TMP_DIR}/iv.bin" "${TMP_DIR}/enc.bin" "${TMP_DIR}/hmac.bin" | base64 | tr -d "\n"
