<!DOCTYPE html>
<html>
	<head>
		<meta content="text/html;charset=utf-8" http-equiv="Content-Type">

		<title><?nsdk getData path="settings:/system/modelName" roles="value" escape="html"?> &ndash; Tencent Xiaowei</title>
		<link rel="stylesheet" type="text/css" href="/style/style.css">

		<script type="text/javascript" src="/jsapi/jquery.min.js"></script>
		<script type="text/javascript" src="/jsapi/nsdk-api.js"></script>
		<script type="text/javascript" src="/jsapi/common.js"></script>
		<script type="text/javascript" src="/scripts/menu.js.fcgi"></script>

		<script type="text/javascript">
			function updateQrCodeImage() {
				NSDK_GetData("txw:qrCode", "value").done(function(r) {
					$("#xiaowei-qr-code").attr("src", r.value.string_);
				});
			}

			function refreshQrCode() {
				NSDK_Activate("txw:refreshQrCode").done(function(r) {
					updateQrCodeImage()
				})
			}

			$(document).ready(function() {
				NSDK_GetData("txw:isWhitelisted", "value").done(function(r) {
					if (r.value.bool_ === true) {
						updateQrCodeImage()
					}
					else {
						$("#xiaowei-not-whitelisted").removeAttr("hidden")
						$("#xiaowei-qr-code-field").attr("hidden", true)
					}
				});
			});
		</script>

	</head>

	<body>
		<div id="menu"></div>
		<fieldset id="xiaowei">
			<legend>Tencent Xiaowei</legend>

			<dl id="xiaowei-not-whitelisted" hidden style="color: red">
				<dt><label>Serial number needs to be whitelisted!</label></dt>
				<dd><p>Your device is not whitelisted on the Xiaowei server. Please provide your device's serial number (<b><?nsdk getData path="settings:/system/serialNumber" roles="value" escape="js"?></b>) to a person responsible for it.</p></dd>
			</dl>
			<dl id="xiaowei-qr-code-field">
				<dt><label>QR Code</label></dt>
				<dd><button type="button" onclick="refreshQrCode()">Refresh QR code</button></dd>
				<dd><img id="xiaowei-qr-code"></dd>
			</dl>
		</fieldset>
	</body>
</html>
