#! /bin/bash

K=85e95417428eb86474d0ca90ad1f08ee50034854db4a3c7465e902c185aea298
KHMAC=b34f16c94918d4be67347aaf5eb35cf7

TMP=/tmp/cast-enckey-$$

# generate IV
dd if=/dev/urandom bs=1 count=16 of=${TMP}-iv.bin 2> /dev/null
IV=`cat ${TMP}-iv.bin | hexdump -v -e '/1 "%02X"'`

openssl enc -e -aes-256-cbc -K $K -iv $IV -nosalt -in "$1" -out ${TMP}-enc.bin
cat ${TMP}-iv.bin ${TMP}-enc.bin | openssl dgst -sha256 -mac HMAC -macopt hexkey:$KHMAC -binary -out ${TMP}-hmac.bin
cat ${TMP}-iv.bin ${TMP}-enc.bin ${TMP}-hmac.bin | base64
rm ${TMP}-iv.bin ${TMP}-enc.bin ${TMP}-hmac.bin
