#! /bin/sh

UPDATED_FILE="/usr/share/nsdk/hostname-updated"

if [ ! -f $UPDATED_FILE ]; then
	MAC=$( (fw_printconst -n eth_int_addr || fw_printconst -n wifi_addr) 2>/dev/null | tr -d ":" | tr '[:upper:]' '[:lower:]')
	if [ -z "$MAC" ]; then
		MAC=$( (cat /sys/class/net/eth0/address || cat /sys/class/net/wlan0/address) 2>/dev/null | tr -d ":")
	fi

	MACHINE_NAME=$(cat "/etc/machine" | tr -d '\n')
	echo "$MACHINE_NAME-$MAC" >"/etc/hostname"
	# On Arcam, the hostname should be in format <model name>-<last 3 octets of WiFi MAC>
	MODEL_NAME=$(fw_printconst model 2> /dev/null | awk '{split($0,arr,"_"); print arr[2]}')
	SHORT_MAC=$(cat /sys/class/net/wlan0/address 2>/dev/null | tr -d ":" | tr -d "\n" | tail -c 6)
	echo "$MODEL_NAME-$SHORT_MAC" >"/etc/hostname"
	sync

	touch $UPDATED_FILE
	hostname -F "/etc/hostname"
fi
