<div id="networkContent">
	<script type="text/javascript">

		var ENCRYPTION_NONE = "none";
		var ENCRYPTION_WEP_OPEN = "wep";
		var ENCRYPTION_WPA_PSK = "wpa_psk";

		var NETWORK_AUTOMATIC = "automatic";
		var NETWORK_WIRED = "wired";
		var NETWORK_WIRELESS = "wireless";
		var NETWORK_SOFTAP = "softap";
		var NETWORK_HYBRID = "hybrid";

		var WIFI_NETWORK_SCAN_POLL_INTERVAL = 500;
		var WIFI_NETWORK_SCAN_TIMEOUT = 10000;
		var wifiNetworkScanPollTimer = null;
		var wifiNetworkScanTimer = null;
		var wifiNetworkScanResults = {};
		var wifiNetworkScanResultsDisplayed = [];
		var scanning = false;
		var currentWirelessSsid = '';
		var currentWirelessEncryption = ENCRYPTION_NONE;
		var currentBssid = '';

		$(document).ready(function() {
			refreshNetworkSettingsForm();

			$('#wirelessNetworks').on('change', function() {
				onFormSsidChanged();
			});
		});

		function $C(val, def) {
			if (val === null || val === undefined)
				return def;
			return val;
		}

		function networkProfile() {
			var ret = $.Deferred();

			NSDK_GetData("network:profile", "value").done(function(result) {
				var profile = result["value"];

				// return profile:
				ret.resolve(profile);
			}).fail( function() {
				ret.reject(null);
			});
			return ret;
		}

		function networkInfo() {
			var ret = $.Deferred();

			NSDK_GetData("network:info", "value").done(function(result) {
				var networkInfo = result["value"];

				//return networkInfo
				ret.resolve(networkInfo)
			}).fail(function() {
				ret.reject(null);
			});
			return ret;
		}

		function isTypeValid(value) {
			var isValid = value == NETWORK_AUTOMATIC ||
				value == NETWORK_WIRED ||
				value == NETWORK_WIRELESS

			return isValid;
		}

		function isFormDhcpValid(value) {
			var isValid = parseInt(value) == 0 || parseInt(value) == 1;
			return isValid;
		}

		function isFormManualValid(value) {
			var isValid = parseInt(value) == 0 || parseInt(value) == 1;
			return isValid;
		}

		function isIpValid(value) {
			var ip = /^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/;
			return value.match(ip) != null;
		}

		function isNetmaskValid(value) {
			var netmask = /^[1-2]{1}[2,4,5,9]{1}[0,2,4,5,8]{1}.[0-2]{1}[0,2,4,5,9]{1}[0,2,4,5,8]{1}.[0-2]{1}[0,2,4,5,9]{1}[0,2,4,5,8]{1}.[0-9]{1,3}$/;
			return value.match(netmask) != null;
		}

		function isSsidValid(value) {
			return (typeof value == 'string' || value instanceof String);
		}

		function isBssidValid(value) {
			return (typeof value == 'string' || value instanceof String);
		}

		function isKeyValid(value) {
			return (typeof value == 'string' || value instanceof String);
		}

		function isEncryptionValid(value) {
			var isValid = value == ENCRYPTION_NONE || value == ENCRYPTION_WEP_OPEN || value == ENCRYPTION_WPA_PSK;
			return isValid;
		}

		function startWirelessNetworkScan() {
			if (scanning == true) return;
			scanning = true;

			clearFormWirelessNetworks();

			wifiNetworkScanPollTimer = setInterval(wirelessNetworkScanResults, WIFI_NETWORK_SCAN_POLL_INTERVAL);
			wifiNetworkScanTimer = setTimeout(stopWirelessNetworkScan, WIFI_NETWORK_SCAN_TIMEOUT);
			wifiNetworkScanResults = {};
			wifiNetworkScanResultsDisplayed = [];

			NSDK_Activate("network:scan");
		}

		function stopWirelessNetworkScan() {
			clearInterval(wifiNetworkScanPollTimer);
			clearTimeout(wifiNetworkScanTimer);
			scanning = false;
		}

		function wirelessNetworkScanResults() {
			NSDK_GetRows("network:scan_results", "title,value", 0, 99).done(function(data){
				if(wifiNetworkScanResults.length != data.rowsCount) {
					wifiNetworkScanResults = data.rows;

					clearTimeout(wifiNetworkScanPollTimer);
					wifiNetworkScanPollTimer = setInterval(wirelessNetworkScanResults, WIFI_NETWORK_SCAN_POLL_INTERVAL);

					setFormWirelessNetworks(wifiNetworkScanResults);
				}
			});
		}

		function makeAutomaticProfile() {
			profile = {};
			profile.networkProfile = {};
			profile.networkProfile.type = formNetworkType();

			return profile;
		}

		function makeWiredProfile() {
			profile = {};
			profile.networkProfile = {};

			profile.networkProfile.type = formNetworkType();
			if(isTypeValid(profile.networkProfile.type) == false) return null;

			profile.networkProfile.wired = {};

			var dhcp = formDhcp(NETWORK_WIRED);
			if (isFormDhcpValid(dhcp) == false) return null;
			profile.networkProfile.wired.dhcp = (parseInt(dhcp) == 1);

			if (isFormDhcp(NETWORK_WIRED) == true) return profile;

			profile.networkProfile.wired.ip = formIp(NETWORK_WIRED);
			if (isIpValid(profile.networkProfile.wired.ip) == false) return null;

			profile.networkProfile.wired.netmask = formNetmask(NETWORK_WIRED);
			if (isNetmaskValid(profile.networkProfile.wired.netmask) == false) return null;

			profile.networkProfile.wired.gateway = formGateway(NETWORK_WIRED);
			if (isIpValid(profile.networkProfile.wired.gateway) == false) return null;

			profile.networkProfile.wired.dns = [];

			var dns0 = formDns(NETWORK_WIRED, 0);
			if (isIpValid(dns0)) profile.networkProfile.wired.dns.push(dns0);

			var dns1 = formDns(NETWORK_WIRED, 1);
			if (isIpValid(dns1)) profile.networkProfile.wired.dns.push(dns1);

			if (profile.networkProfile.wired.dns.length <= 0) return null;

			return profile;
		}

		function makeWirelessProfile() {
			profile = {};
			profile.networkProfile = {};

			profile.networkProfile.type = formNetworkType();
			if(isTypeValid(profile.networkProfile.type) == false) return null;

			profile.networkProfile.wireless = {};

			var dhcp = formDhcp(NETWORK_WIRELESS);
			if (isFormDhcpValid(dhcp) == false) return null;
			profile.networkProfile.wireless.dhcp = (parseInt(dhcp) == 1);

			if (isFormDhcp(NETWORK_WIRELESS) == false) {

				profile.networkProfile.wireless.ip = formIp(NETWORK_WIRELESS);
				if (isIpValid(profile.networkProfile.wireless.ip) == false) return null;

				profile.networkProfile.wireless.netmask = formNetmask(NETWORK_WIRELESS);
				if (isNetmaskValid(profile.networkProfile.wireless.netmask) == false) return null;

				profile.networkProfile.wireless.gateway = formGateway(NETWORK_WIRELESS);
				if (isIpValid(profile.networkProfile.wireless.gateway) == false) return null;

				profile.networkProfile.wireless.dns = [];

				var dns0 = formDns(NETWORK_WIRELESS, 0);
				if (isIpValid(dns0)) profile.networkProfile.wireless.dns.push(dns0);

				var dns1 = formDns(NETWORK_WIRELESS, 1);
				if (isIpValid(dns1)) profile.networkProfile.wireless.dns.push(dns1);

				if (profile.networkProfile.wireless.dns.length <= 0) return null;
			}

			profile.networkProfile.wireless.ssid = formSsid();
			if (isSsidValid(profile.networkProfile.wireless.ssid) == false) return null;

			profile.networkProfile.wireless.encryption = formEncryption();
			if (isEncryptionValid(profile.networkProfile.wireless.encryption) == false) return null;

			if (isKeyRequired()) {
				profile.networkProfile.wireless.key = formKey();
				if (isKeyValid(profile.networkProfile.wireless.key) == false) return null;
			}

			profile.networkProfile.wireless.manual = formManualWireless(NETWORK_WIRELESS);
			if (isFormManualValid(profile.networkProfile.wireless.manual) == false) return null;

			if (isBssidValid(formBssid())) {
				profile.networkProfile.wireless.bssid = formBssid();
			}

			return profile;
		}

		function submitNetworkSettingsForm() {
			var profile = {}
			var profileType = formNetworkType();
			var profileValid = false;
			switch (profileType) {
				case NETWORK_AUTOMATIC:
					$.extend(true, profile, makeWiredProfile(), makeWirelessProfile(), makeAutomaticProfile());
					break;
				case NETWORK_WIRED:
					profile = makeWiredProfile();
					break;
				case NETWORK_WIRELESS:
					profile = makeWirelessProfile();
					break;
				default:
					profile = null;
			}

			if (profile == null) {
				return;
			}

			networkInfo().done(function(info) {
				setNetworkProfile(profile, info);
			}).fail(function() {
				setNetworkProfile(profile);
			});
		}

		function refreshNetworkSettingsForm() {
			setFormDefaultWiredSettings();
			setFormDefaultWirelessSettings();

			networkProfile().done(function(profile) {

				if (profile.hasOwnProperty("networkProfile") == false) return;

				setFormNetworkType(profile.networkProfile.type);

				if (profile.networkProfile.hasOwnProperty("wired") == true) {
					setFormDhcp(NETWORK_WIRED, $C(profile.networkProfile.wired.dhcp, 1));

					setFormIp(NETWORK_WIRED, $C(profile.networkProfile.wired.ip, ""));
					setFormNetmask(NETWORK_WIRED, $C(profile.networkProfile.wired.netmask, ""));
					setFormGateway(NETWORK_WIRED, $C(profile.networkProfile.wired.gateway, ""));

					if (profile.networkProfile.wired.hasOwnProperty("dns")) {
						setFormDns(NETWORK_WIRED, 0, $C(profile.networkProfile.wired.dns[0], ""));
						setFormDns(NETWORK_WIRED, 1, $C(profile.networkProfile.wired.dns[1], ""));
					}
				}

				if (profile.networkProfile.hasOwnProperty("wireless") == true) {
					setFormDhcp(NETWORK_WIRELESS, $C(profile.networkProfile.wireless.dhcp, 1));

					setFormIp(NETWORK_WIRELESS, $C(profile.networkProfile.wireless.ip, ""));
					setFormNetmask(NETWORK_WIRELESS, $C(profile.networkProfile.wireless.netmask, ""));
					setFormGateway(NETWORK_WIRELESS, $C(profile.networkProfile.wireless.gateway, ""));

					if (profile.networkProfile.wireless.hasOwnProperty("dns")) {
						setFormDns(NETWORK_WIRELESS, 0, $C(profile.networkProfile.wireless.dns[0], ""));
						setFormDns(NETWORK_WIRELESS, 1, $C(profile.networkProfile.wireless.dns[1], ""));
					}

					setFormSsid($C(profile.networkProfile.wireless.ssid, ""));
					showFormSsid($C(profile.networkProfile.wireless.ssid, ""));
					setFormEncryption($C(profile.networkProfile.wireless.encryption, ENCRYPTION_NONE));
					showFormEncryption($C(profile.networkProfile.wireless.encryption, ENCRYPTION_NONE));
					setFormBssid($C(profile.networkProfile.wireless.bssid, ""));
					showFormBssid($C(profile.networkProfile.wireless.bssid, ""));
					setFormKey($C(profile.networkProfile.wireless.key, ""));

					setFormManualWireless($C(profile.networkProfile.wireless.manual, 0));
				}

				onFormNetworkTypeChanged();
			});
		}

		function onFormNetworkTypeChanged() {
			var networkType = formNetworkType();
			switch (networkType) {
				case NETWORK_AUTOMATIC:
					showWiredSettings();
					showWirelessSettings();
					break;
				case NETWORK_WIRED:
					showWiredSettings();
					hideWirelessSettings();
					break;
				case NETWORK_WIRELESS:
					hideWiredSettings();
					showWirelessSettings();
					break;
			}
		}

		function setFormDefaultWiredSettings() {
			setFormDhcp(NETWORK_WIRED, 1);
		}

		function setFormDefaultWirelessSettings() {
			setFormDhcp(NETWORK_WIRELESS, 1);
			setFormEncryption(ENCRYPTION_NONE);
			showKeyInput(false);
			setFormManualWireless(0);
		}

		function setFormWirelessNetworks(networks) {
			var networksElement = $("#wirelessNetworks");

			if ($("#wirelessNetworks .ssidStatic").length == 0) {
				networksElement.append("<dt><label class=\"ssidStatic\">SSID (scanning...)</label></dt>");
			}
			else if (networks.length > 0) {
				$("#wirelessNetworks .ssidStatic").html("<dt><label class=\"ssidStatic\">SSID</label></dt>");
			}

			for (var i = 0; i < networks.length; i++) {
				var name = networks[i][0];
				if (wifiNetworkScanResultsDisplayed.indexOf(name) >= 0)
					continue;

				wifiNetworkScanResultsDisplayed.push(name);
				networksElement.append(
					"<dd>" +
						"<input type=\"radio\" class= \"networksRadioCls\" name=\"networksRadio\" "+
						"value=\"" + textToHtml(name) + "\"/>" + textToHtml(name) +
					"</dd>");
			}
		}

		function clearFormWirelessNetworks() {
			$("#wirelessNetworks").html("");
		}

		function formNetworkType() {
			return $('input[name=typeDynamic]:checked').val();
		}

		function setFormNetworkType(value) {
			var index;
			switch (value) {
				case NETWORK_AUTOMATIC:
					index = 0;
					break;
				case NETWORK_WIRED:
					index = 1;
					break;
				case NETWORK_WIRELESS:
					index = 2;
					break;
				default:
					return;
			}

			$('input[name=typeDynamic]')[index].checked = true;
		}

		function formIp(network) {
			var ip = 0;
			switch (network) {
				case NETWORK_WIRED:
					ip = $("#wiredSettings .ipDynamic").val();
					break;
				case NETWORK_WIRELESS:
					ip = $("#wirelessSettings .ipDynamic").val();
					break;
				default:
					break;
			}

			return ip;
		}

		function setFormIp(network, value) {
			switch (network) {
				case NETWORK_WIRED:
					$("#wiredSettings .ipDynamic").val(value);
					break;
				case NETWORK_WIRELESS:
					$("#wirelessSettings .ipDynamic").val(value);
					break;
				default:
					break;
			}
		}

		function formIpValidator(obj) {
			var valid = isIpValid($(obj).val()) || $(obj).val() == "";
			if (valid) {
				obj.style.color="black";
			} else {
				obj.style.color="red";
			}
		}

		function formNetmask(network) {
			var netmask = 0;
			switch (network) {
				case NETWORK_WIRED:
					netmask = $("#wiredSettings .netmaskDynamic").val();
					break;
				case NETWORK_WIRELESS:
					netmask = $("#wirelessSettings .netmaskDynamic").val();
					break;
				default:
					break;
			}

			return netmask;
		}

		function setFormNetmask(network, value) {
			switch (network) {
				case NETWORK_WIRED:
					$("#wiredSettings .netmaskDynamic").val(value);
					break;
				case NETWORK_WIRELESS:
					$("#wirelessSettings .netmaskDynamic").val(value);
					break;
				default:
					break;
			}
		}

		function formNetmaskValidator(obj) {
			var valid = isNetmaskValid($(obj).val()) || $(obj).val() == "";
			if (valid) {
				obj.style.color="black";
			} else {
				obj.style.color="red";
			}
		}

		function formGateway(network) {
			var gateway = 0;
			switch (network) {
				case NETWORK_WIRED:
					gateway = $("#wiredSettings .gatewayDynamic").val();
					break;
				case NETWORK_WIRELESS:
					gateway = $("#wirelessSettings .gatewayDynamic").val();
					break;
				default:
					break;
			}

			return gateway;
		}

		function setFormGateway(network, value) {
			switch (network) {
				case NETWORK_WIRED:
					$("#wiredSettings .gatewayDynamic").val(value);
					break;
				case NETWORK_WIRELESS:
					$("#wirelessSettings .gatewayDynamic").val(value);
					break;
				default:
					break;
			}
		}

		function formGatewayValidator(obj) {
			var valid = isIpValid($(obj).val()) || $(obj).val() == "";
			if (valid) {
				obj.style.color="black";
			} else {
				obj.style.color="red";
			}
		}

		function formDns(network, index) {
			var dns = 0;
			switch (network) {
				case NETWORK_WIRED:
					dns = $("#wiredSettings .dnsDynamic" + index).val();
					break;
				case NETWORK_WIRELESS:
					dns = $("#wirelessSettings .dnsDynamic" + index).val();
					break;
				default:
					break;
			}

			return dns;
		}

		function setFormDns(network, index, value) {
			switch (network) {
				case NETWORK_WIRED:
					$("#wiredSettings .dnsDynamic" + index).val(value);
					break;
				case NETWORK_WIRELESS:
					$("#wirelessSettings .dnsDynamic" + index).val(value);
					break;
				default:
					break;
			}
		}

		function formDnsValidator(obj) {
			var valid = isIpValid($(obj).val()) || $(obj).val() == "";
			if (valid) {
				obj.style.color="black";
			} else {
				obj.style.color="red";
			}
		}

		function isFormDhcp(network) {
			if (network == NETWORK_WIRED)
				return parseInt($('input[name=dhcpDynamicWired]:checked').val()) == 1;
			else if (network == NETWORK_WIRELESS)
				return parseInt($('input[name=dhcpDynamicWireless]:checked').val()) == 1;
			else
				return false;
		}

		function formDhcp(network) {
			var dhcp = -1;
			switch (network) {
				case NETWORK_WIRED:
					dhcp = $('input[name=dhcpDynamicWired]:checked').val();
					break;
				case NETWORK_WIRELESS:
					dhcp = $('input[name=dhcpDynamicWireless]:checked').val();
					break;
				default:
					break;
			}
			return dhcp;
		}

		function setFormDhcp(network, value) {
			var dhcp = -1;
			switch (network) {
				case NETWORK_WIRED:
					dhcp = $('input[name=dhcpDynamicWired]')[Number(value)].checked = true;
					break;
				case NETWORK_WIRELESS:
					dhcp = $('input[name=dhcpDynamicWireless]')[Number(value)].checked = true;
					break;
				default:
					break;
			}
		}

		function onFormDhcpChanged(network) {
			var dhcpEnabled = formDhcp(network) == true;
			if (dhcpEnabled == true) {
				hideNetworkSettings(network);
			} else {
				showNetworkSettings(network);
			}
		}

		function formManualWireless() {
			return $('input[name=manualWirelessSettings]:checked').val();
		}

		function setFormManualWireless(value) {
			$('input[name=manualWirelessSettings]')[value].checked = true;
			onFormManualWirelessChanged();
		}

		function isFormManualWireless() {
			return parseInt($('input[name=manualWirelessSettings]:checked').val()) == 1;
		}

		function onFormManualWirelessChanged() {
			var isManualSet = isFormManualWireless();
			if (isManualSet) {
				$('.manualWirelessSettings').show();
			} else {
				$('.manualWirelessSettings').hide();
			}
		}

		function formSsid() {
			return currentWirelessSsid;
		}

		function setFormSsid(value) {
			currentWirelessSsid = value;
		}

		function showFormSsid(value) {
			if (value != "") {
				var networksElement = $("#wirelessNetworks");
				networksElement.append("<dt><label class=\"ssidStatic\">SSID</label></dt>");
				networksElement.append(
					"<dd>" +
						"<input type=\"radio\" checked=\"checked\" class= \"networksRadioCls\" name=\"networksRadio\" " +
						"value=\"" + textToHtml(value) + "\"/>" + textToHtml(value) +
					"</dd>");
			}
		}

		function formKey() {
			return $('#wirelessSettings .keyDynamic').val();
		}

		function setFormKey(value) {
			$('#wirelessSettings .keyDynamic').val(value);
		}

		function isKeyRequired() {
			return formEncryption() == ENCRYPTION_WEP_OPEN || formEncryption() == ENCRYPTION_WPA_PSK;
		}

		function formBssid() {
			return currentBssid;
		}

		function setFormBssid(value) {
			currentBssid = value;
		}

		function showFormBssid(value) {
			$('#wirelessSettings .hiddenNetworkNameCls').val(value);
		}

		function formEncryption() {
			return currentWirelessEncryption;
		}

		function setFormEncryption(value) {
			currentWirelessEncryption = value;
		}

		function showFormEncryption(value) {
			var encryptionType = -1;
			switch (value) {
				case ENCRYPTION_NONE:
					encryptionType = 0;
					break;
				case ENCRYPTION_WEP_OPEN:
					encryptionType = 1;
					break;
				case ENCRYPTION_WPA_PSK:
					encryptionType = 2;
					break;
				default:
					break;
			}

			if (encryptionType == -1) return;

			$('input[name=encryptionDynamic]')[encryptionType].checked = true;

			onFormEncryptionChanged();
		}


		function onFormEncryptionChanged() {
			setFormKey('');

			var encryptionType = $('input[name=encryptionDynamic]:checked').val();
			switch (encryptionType) {
				case ENCRYPTION_NONE:
					showKeyInput(false);
					break;
				case ENCRYPTION_WEP_OPEN:
				case ENCRYPTION_WPA_PSK:
					showKeyInput(true);
					break;
			}
			setFormEncryption(encryptionType);
		}

		function showKeyInput(value) {
			if (value) {
				$('.keyForm').show();
			}
			else {
				$('.keyForm').hide();
			}
		}

		function onFormHiddenNetworkChanged() {
			$(".networksRadioCls").prop('checked', false);
			setFormSsid($(".hiddenNetworkNameCls").val());
			setFormBssid('');
			setFormKey('');
		}

		function onFormSsidChanged() {
			var ssid = $('input[name=networksRadio]:checked', '#wirelessNetworks').val();
			$(".hiddenNetworkNameCls").val('');
			setFormKey('');

			var ssidIndex = 0;
			for (; ssidIndex < wifiNetworkScanResults.length; ++ssidIndex) {
				if (ssid == wifiNetworkScanResults[ssidIndex][0]) break;
			}

			if (ssidIndex == wifiNetworkScanResults.length || Object.getOwnPropertyNames(wifiNetworkScanResults).length == 0) return;

			// store network ssid and clear bssid
			setFormSsid(ssid);
			setFormBssid('');

			showFormEncryption(wifiNetworkScanResults[ssidIndex][1].networkScanResult.encryption);
		}

		function setFormTargetType(value) {
			var index;
			switch (value) {
				case NETWORK_AUTOMATIC:
					index = 0;
					break;
				case NETWORK_WIRED:
					index = 1;
					break;
				case NETWORK_WIRELESS:
					index = 2;
					break;
				default:
					return;
			}

			$('input[name=typeDynamic]')[index].checked = true;
		}

		function showNetworkSettings(network) {
			if (network == NETWORK_WIRED) {
				$('#wiredSettings .manualNetworkSettings').show();
			} else {
				$('#wirelessSettings .manualNetworkSettings').show();
			}
		}

		function hideNetworkSettings(network) {
			if (network == NETWORK_WIRED) {
				$('#wiredSettings .manualNetworkSettings').hide();
			} else {
				$('#wirelessSettings .manualNetworkSettings').hide();
			}
		}

		function showWiredSettings() {
			$('#wiredSettings').show();
			onFormDhcpChanged(NETWORK_WIRED);
		}

		function hideWiredSettings() {
			$('#wiredSettings').hide();
		}

		function showWirelessSettings() {
			$('#wirelessSettings').show();
			onFormDhcpChanged(NETWORK_WIRELESS);
		}

		function hideWirelessSettings() {
			$('#wirelessSettings').hide();
		}
	</script>

	<fieldset id="settings">
		<legend>Network Settings</legend>
		<dl>
			<dt><label id="typeStatic">Type</label></dt>
			<dd>
				<input id="radio_type_automatic" type="radio" name="typeDynamic" value="automatic" onClick="onFormNetworkTypeChanged()"/>automatic
				<input id="radio_type_wired" type="radio" name="typeDynamic" value="wired" onClick="onFormNetworkTypeChanged()"/>wired
				<input id="radio_type_wireless" type="radio" name="typeDynamic" value="wireless" onClick="onFormNetworkTypeChanged()"/>wireless
			</dd>
		</dl>
	</fieldset>

	<fieldset id="wiredSettings">
		<legend>Wired Settings</legend>

		<dl>
			<dt><label class="dhcpStatic">DHCP</label></dt>
			<dd>
				<input class="radio_dhcp_off" type="radio" name="dhcpDynamicWired" value="0" onClick="onFormDhcpChanged(NETWORK_WIRED)">no
				<input class="radio_dhcp_on" type="radio" name="dhcpDynamicWired" value="1" onClick="onFormDhcpChanged(NETWORK_WIRED)">yes
			</dd>
		</dl>

		<div class="manualNetworkSettings">
		<hr>
			<dl>
				<dt><label class="ipStatic">IP</label></dt>
				<dd><input type="text" class="ipDynamic" oninput="formIpValidator(this)"/></dd>
			</dl>

			<dl>
				<dt><label class="netmaskStatic">Netmask</label></dt>
				<dd><input type="text" class="netmaskDynamic" oninput="formNetmaskValidator(this)"></dd>
			</dl>

			<dl>
				<dt><label class="gatewayStatic">Gateway</label></dt>
				<dd><input type="text" class="gatewayDynamic" oninput="formGatewayValidator(this)"/></dd>
			</dl>

			<dl>
				<dt><label class="dnsStatic">DNS</label></dt>
				<dd><input type="text" class="dnsDynamic0" oninput="formDnsValidator(this)"/> <input type="text" class="dnsDynamic1" oninput="formDnsValidator(this)"/></dd>
			</dl>
		</div>
	</fieldset>

	<fieldset id="wirelessSettings">
		<legend>Wireless Settings</legend>
		<dl>
			<dt><label class="dhcpStatic">DHCP</label></dt>
			<dd>
				<input class="radio_dhcp_off" type="radio" name="dhcpDynamicWireless" value="0" onClick="onFormDhcpChanged(NETWORK_WIRELESS)">no
				<input class="radio_dhcp_on" type="radio" name="dhcpDynamicWireless" value="1" onClick="onFormDhcpChanged(NETWORK_WIRELESS)">yes
			</dd>
		</dl>

		<div class="manualNetworkSettings">
			<hr>
			<dl>
				<dt><label class="ipStatic">IP</label></dt>
				<dd><input type="text" class="ipDynamic" oninput="formIpValidator(this)"/></dd>
			</dl>

			<dl>
				<dt><label class="netmaskStatic">Netmask</label></dt>
				<dd><input type="text" class="netmaskDynamic" oninput="formNetmaskValidator(this)"></dd>
			</dl>

			<dl>
				<dt><label class="gatewayStatic">Gateway</label></dt>
				<dd><input type="text" class="gatewayDynamic" oninput="formGatewayValidator(this)"/></dd>
			</dl>

			<dl>
				<dt><label class="dnsStatic">DNS</label></dt>
				<dd><input type="text" class="dnsDynamic0" oninput="formDnsValidator(this)"/> <input type="text" class="dnsDynamic1" oninput="formDnsValidator(this)"/></dd>
			</dl>
		</div>

		<hr>
		<dl>
			<dt><label class="ssidStatic">Find available networks</label></dt>
			<dd>
				<button type="button" onclick="startWirelessNetworkScan()">Start scan</button>
			</dd>
		</dl>
		<dl id="wirelessNetworks"></dl>
		<dl class="keyForm">
			<dt><label class="keyStatic">Password</label></dt>
			<dd><input type="password" class="keyDynamic"/></dd>
		</dl>

		<dl>
			<dt><label>Manual Settings</label></dt>
			<dd>
				<input class="radio_manual_wireless_off" type="radio" name="manualWirelessSettings" value="0" onClick="onFormManualWirelessChanged()"/>no
				<input class="radio_manual_wireless_on" type="radio" name="manualWirelessSettings" value="1" onClick="onFormManualWirelessChanged()"/>yes
			</dd>
		</dl>

		<div class="manualWirelessSettings">
			<dl>
				<dt><label class="ssidStatic">Hidden network name</label></dt>
				<dd>
					<input type="text" class="hiddenNetworkNameCls" oninput="onFormHiddenNetworkChanged()">
				</dd>
			</dl>
			<dl>
				<dt><label class="encryptionStatic">Encryption</label></dt>
				<dd>
					<input class="radio_encryption_none" type="radio" name="encryptionDynamic" value="none" onClick="onFormEncryptionChanged()" checked/>none
					<input class="radio_encryption_wep_open" type="radio" name="encryptionDynamic" value="wep" onClick="onFormEncryptionChanged()"/>wep open
					<input class="radio_encryption_wpa_psk" type="radio" name="encryptionDynamic" value="wpa_psk" onClick="onFormEncryptionChanged()"/>wpa psk
				</dd>
			</dl>
		</div>
	</fieldset>
	<button type="button" onclick="submitNetworkSettingsForm()">Configure</button><br>
</div>
