var assistantList = JSON.parse('<?nsdk getData path="master:assistantList" roles="value" escape="js"?>');
var activeAssistant = '<?nsdk getData path="settings:/system/activeAssistant" roles="value" escape="js"?>'

function isAssistantActive(assistant)
{
	// assistant must be listed in the list of assistants on this build
	if (assistantList.stringList.includes(assistant)) {
		// activeAssistant is valid only if there is more than 1 assistant on this build
		if (assistantList.stringList.length > 1) {
			return assistant == activeAssistant
		}
		else {
			// there is only one assistant on this build, it has to be active
			return true
		}
	}
	else {
		return false
	}
}

$(document).ready(function()
{
	var avrSetupUtilityEnabled = '<?nsdk getData path="settings:/www/avrSetupUtilityEnabled" roles="value" escape="js"?>';
	var googlecast = '<?nsdk getData path="googlecast:/assistantState" roles="value" escape="js"?>';
	var nymea = '<?nsdk getData path="settings:/nymea/enabled" roles="value" escape="js"?>';
	var reporting = '<?nsdk getData path="reporting:makeUserReport" roles="value" escape="js"?>';

	var menu = '<ul class="menu">';

	if (avrSetupUtilityEnabled == "true") {
		menu += '<li><a href="/setup">Setup</a></li>';
	}

	menu +=	'<li><a href="/index.fcgi">Main Page</a></li>\
			<li><a href="/settings.fcgi">Device Settings</a></li>\
			<li><a href="/network.fcgi">Network Settings</a></li>\
			';

	// GoogleCast page needs to be shown even if there is no voice assistant, so we can't use isAssistantActive.
	// Assistant state node actually also exists even on non-assistant builds!
	if (!googlecast.startsWith('[[')) {
		menu += '<li><a href="/googlecast.fcgi">Google Cast</a></li>'
	}

	/**
	if (isAssistantActive("Alexa Voice Service")) {
		menu += '<li><a href="/alexa.fcgi">Alexa Voice</a></li>'
	}

	if (isAssistantActive("Tencent Voice Service - Xiaowei")) {
		menu += '<li><a href="/xiaowei.fcgi">Tencent Xiaowei</a></li>'
	}

	if (assistantList.stringList.length > 1) {
		menu += '<li><a href="/assistant.fcgi">Assistant Selection</a></li>'
	}

	if (!nymea.startsWith('[[')) {
		menu += '<li><a href="/nymea.fcgi">Nymea</a></li>'
	}

	if (!reporting.startsWith('[[')) {
		menu += '<li><a href="/reporting.fcgi">Bug report</a></li>'
	}
	**/

	menu +=
		'<li><a href="/webclient">Webclient</a></li>\
		</ul>\
		';

	$("#menu").html(menu);
});
