#!/usr/bin/env sh

set -e

FW_PRINTCONST=/sbin/fw_printconst

get_location_from_const() {
	location=$($FW_PRINTCONST wifiRegulatoryDomain | cut -f 2 -d '=')
	if [ $? == 1 -o -z $location ]; then
		location="00"
	fi

	echo "${location}"
}

get_regdb_region() {
	location=$1

	# This dumps the regulatory information and extracts the
	# regulatory region like ETSI, FCC, JP or UNSET
	region=$(/usr/sbin/regdbdump /usr/lib/crda/regulatory.bin 2>&1 | grep "country ${location}" | cut -f 2 -d -)
	if [ -z "${region}" ]; then
		region="UNSET"
	fi

	echo "${region}"
}
