#! /bin/sh

# Script to handle swupdate status information, this script is called
# when swupdate process is being started, when progress information is
# reported and swupdate exits
# Swupdate exit message can be emited without start, for example if
# network initialization failed
#
# Messages:
#	initialize - starting swupdate script
#	copy begin - start copy file from storage to ram
#	copy progress <percentage> - progress of copying file
#	copy success - file copy successfully
#	copy failed - file copy failed
#	start uri - swupdate process is going to download image from uri
#	start usb - swupdate process is going to use local file from usb
#	start file - swupdate process is going to use local file from flash
#	start webserver - swupdate process is going to open local webpage to upload file
#	update start - start downloading image or uploading over web page
#	update download <percentage> - swupdate download progress in percentage
#	update install <num of stages> <stage> <percentage> - swupdate install progress in percentage
#	update success - swupdate success
#	update failure - swupdate failed
#	exit success - swupdate finished successfuly
#	exit failed network_error - failed to initialize network
#	exit failed swupdate_error - error occured during update process


# run all scripts in /usr/share/swupdate with received arguments
find "/usr/share/swupdate" -name "*.sh" -type f -exec \{\} "$@" \;
