"use strict";
window.playId = null;
var volumeUpdateFromWebclient = false;
var volumeUpdateFromStreamSdk = false;

function iconPath(value, _defaultValue) {
	if (_defaultValue === undefined) {
		_defaultValue = "";
	}
	let icon = _defaultValue;
	switch (value) {
		case "skin:iconFiles":
			icon = "img/AllFiles.png";
			break;
		case "skin:iconMultiroom":
			icon = "img/SueGrouping.png";
			break;
		case "skin:iconRecentlyPlayed":
			icon = "img/RecentlyPlayed.png";
			break;
		case "skin:iconFavorites":
			icon = "img/Favorites.png";
			break;
		case "skin:iconPAF":
			icon = "img/PAF.png";
			break;
		case "skin:iconPlaylists":
			icon = "img/Playlists.png";
			break;
		case "skin:iconUsb":
			icon = "img/USB.png";
			break;
		case "skin:iconCdrom":
			icon = "img/Cdrom.png";
			break;
		case "skin:iconvTuner":
			icon = "img/InternetRadios.png";
			break;
		case "skin:iconTuneIn":
			icon = "img/TuneIn.png";
			break;
		case "skin:iconMediaLibrary":
			icon = "img/MediaServers.png";
			break;
		case "skin:iconSettings":
			icon = "img/Settings.png";
			break;
		case "skin:iconSirius":
			icon = "img/Sirius.png";
			break;
		case "skin:iconAUX":
			icon = "img/LINEIN.png";
			break;
		case "skin:iconOptics":
			icon = "img/Optics.png";
			break;
		case "skin:iconBluetooth":
			icon = "img/Bluetooth.png";
			break;
		case "skin:iconAirPlay":
			icon = "img/AirPlay.png";
			break;
		case "skin:iconSpotify":
			icon = "img/Spotify.png";
			break;
		case "skin:iconTidal":
			icon = "img/Tidal.png";
			break;
		case "skin:iconMusicLibrary":
			icon = "img/MusicLibrary.png";
			break;
		case "skin:iconAirable":
			icon = "img/Airable.png";
			break;
		case "skin:iconAirableRadios":
			icon = "img/Airable.png";
			break;
		case "skin:iconAirablePodcasts":
			icon = "img/Airable.png";
			break;
		case "skin:logoTuneIn":
			icon = "img/TuneIn.png";
			break;
		case "skin:iconTuneInMyPresets":
			icon = "img/Favorites.png";
			break;
		case "skin:iconTuneInLocalRadio":
			icon = "img/Folder.png";
			break;
		case "skin:iconTuneInMusic":
			icon = "img/Folder.png";
			break;
		case "skin:iconTuneInTalk":
			icon = "img/Folder.png";
			break;
		case "skin:iconTuneInSports":
			icon = "img/Folder.png";
			break;
		case "skin:iconTuneInByLocation":
			icon = "img/Folder.png";
			break;
		case "skin:iconTuneInByLanguage":
			icon = "img/Folder.png";
			break;
		case "skin:iconTuneInPodcasts":
			icon = "img/Folder.png";
			break;
		case "skin:iconAmazonMusic":
			icon = "img/AmazonMusic.png";
			break;
		case "skin:iconHighresAudio":
			icon = "img/HighresAudio.png";
			break;
		case "skin:iconNapster":
			icon = "img/Napster.png";
			break;
		case "skin:iconDeezer":
			icon = "img/Deezer.png";
			break;
		case "skin:iconQobuz":
			icon = "img/Qobuz.png";
			break;
		case "skin:iconMusic":
			icon = "img/Noten.png";
			break;
		case "skin:iconDab":
			icon = "img/Dab.png";
			break;
		case "skin:iconFm":
			icon = "img/Fm.png";
			break;
		case "skin:iconPandora":
			icon = "img/Pandora.png";
			break;
		case "skin:iconHdmi":
			icon = "img/Hdmi.png";
			break;
		case "skin:iconUsbAudio":
			icon = "img/Noten.png";
			break;
			// webclient related icons  ..
		case "skin:iconCheckboxChecked":
			icon = "img/Checked.png";
			break;
		case "skin:iconCheckboxUnchecked":
			icon = "img/Unchecked.png";
			break;
		case "skin:iconEnum":
			icon = "img/Folder.png";
			break;
		case "skin:iconAudio":
			icon = "img/Noten.png";
			break;
		case "skin:iconContainer":
			icon = "img/Folder.png";
			break;
		case "skin:iconBlank":
			icon = "img/blank.png";
			break;
		case "skin:iconContext":
			icon = "img/btn/MENU.png";
			break;
		default:
			if (value && value.startsWith("http"))
				icon = value;
			break;
	}

	if (icon == "") {
		console.warn("iconPath: unknown icon '" + value + "'");
	}

	return icon;
}

function switchView(view, browser) {
	/* Determine current view */
	var current_view = null;
	if ($("#album-info").css("display") == "none")
		current_view = "content-browser";
	else if ($("#content-browser").css("display") == "none")
		current_view = "album-info";
	if ($("#album-info").hasClass("twopane") &&
		$("#content-browser").hasClass("twopane")) {
		/* Both panes are visible */
		current_view = "twopane";
	}

	if (view == undefined) {
		if (current_view == "album-info")
			view = "content-browser";
		if (current_view == "content-browser")
			view = "album-info";
	}

	/* If we are in twopane layout, ignore switching */
	if (current_view == "twopane")
		view = "twopane";

	switch (view) {
		case "album-info":
			$("#content-browser").hide("fast");
			browser.deactivate();
			$("#album-info").show("fast");
			break;
		case "content-browser":
			$("#album-info").hide("fast");
			$("#content-browser").show("fast");
			browser.activateCurrent();
			break;
		case "twopane":
			$("#album-info").show("fast");
			$("#content-browser").show("fast");
	}
}

function layout(l, browser) {
	var elements = ["album-info", "player", "content-browser"];

	if (l == "toggle") {
		if ($("#player").hasClass("twopane"))
			l = "compact";
		if ($("#player").hasClass("compact"))
			l = "twopane";
	}

	switch (l) {
		case "compact":
			for (var e in elements) {
				$("#" + elements[e]).addClass("compact");
				$("#" + elements[e]).removeClass("twopane");
			}
			switchView("album-info", browser);
			break;
		case "twopane":
			for (e in elements) {
				$("#" + elements[e]).removeClass("compact");
				$("#" + elements[e]).addClass("twopane");
			}
			switchView("twopane", browser);
			break;
	}

	//emit 'RESIZE' event every time the view is changed,
	//so that browser's height will be recalculated to fit
	//the web page
	$(window).trigger("resize");
}

/* Browser updates handling */
function onBrowsingError(error) {
	/* Show an error, if there was one */
	if ($.isEmptyObject(error)) {
		$("#browsing-error-container").hide("fast");
		$("#browsing-error").html("<br/><br/>No Error");
	} else {
		$("#browsing-error").html(error.title + "<br/><br/>" + error.message);
		$("#browsing-error-container").show("fast");
	}
}

/* Playback errors handling */
function onPlaybackErrorShowHide(message) {
	/* Show an error, if there was one */
	if (message) {
		$("#playback-error-container").show("fast");
		$("#playback-error").html(message);
	} else {
		$("#playback-error-container").hide("fast");
		$("#playback-error").html("No Error");
	}
}

/* Show or hide the progress window */
function onBrowserWorkingStateChange(working) {
	if (working) {
		$("#working").show();
	} else {
		$("#working").hide();
	}
}

/* Show/hide the ".." item ecah time the browser content gets changed */
function onRenderRowsEvent(page, browser) {
	if (page.getPath() != browser.getRoot()) {
		$("#item-level-up").show();
	} else {
		$("#item-level-up").hide();
	}
	$(window).trigger("resize");
}

function onDataStateChange(ui, browser) {
	$("#title").html(ui.title);
	$("#artist").html(ui.artist);
	$("#album").html(ui.album);
	$("#codec").html(ui.codec);
	$("#audioFormat").html(ui.audioFormat);
	$("#mqa").html(ui.mqa);
	$("#progress-background").slider("option", "max", ui.playTimeTotal);
	$("#progress-background").slider("option", "disabled", ui.seekTime);

	if (ui.icon) {
		let iconSrc = iconPath(ui.icon, "default-albumart.jpeg");
		if ($("#albumart").val("src") != iconSrc) {
			$("#albumart").attr("src", iconSrc);
		}
	} else
		$("#albumart").attr("src", "default-albumart.jpeg");

	$("#btn-prev").css("visibility", ["hidden", "visible"][ui.buttons.previous + 0]);
	$("#btn-next").css("visibility", ["hidden", "visible"][ui.buttons.next + 0]);
	$("#btn-contextmenu").css("visibility", ["hidden", "visible"][(ui.contextPath != null) + 0]);
	$("#btn-shuffle").css("visibility", ["hidden", "visible"][ui.playmode.shuffle + 0]);
	$("#btn-repeat").css("visibility", ["hidden", "visible"][ui.playmode.repeat + 0]);

	/* Play button icon depends on player state */
	var img = "";
	if (ui.state == "playing") {
		if (ui.buttons.pause) img = "img/btn/PAUSE.png";
		else img = "img/btn/STOP.png";
	} else img = "img/btn/PLAY.png";
	$("#btn-playpause img").attr("src", img);

	/* Show an error, if there was one */
	onPlaybackErrorShowHide(ui.error ? "Player error<br/><br/>" + ui.error : "");

	if (JSON.stringify(ui.playId) != JSON.stringify(window.playId)) {
		window.playId = ui.playId;
		switchView("album-info", browser);
	}
}

function onPlayModeChange(ui) {
	/* Repeat and shuffle button icon depend on playMode status */
	var img = "";
	if (ui.buttons.repeat == 1) {
		img = "img/btn/REPEATONE.png";
	} else if (ui.buttons.repeat == 2) {
		img = "img/btn/REPEATALL.png";
	} else {
		img = "img/btn/REPEATOFF.png";
	}
	$("#btn-repeat img").attr("src", img);

	if (ui.buttons.shuffle) {
		img = "img/btn/SHUFFLEON.png";
	} else {
		img = "img/btn/SHUFFLEOFF.png";
	}
	$("#btn-shuffle img").attr("src", img);
	/* Show an error, if there was one */
	onPlaybackErrorShowHide(ui.error ? "Error<br/><br/>" + ui.error : "");
}

function onProgressChange(ui) {
	if (ui.playTime <= ui.playTimeTotal) {
		$("#progress-background").slider("option", "value", ui.playTime);

		$("#progress-current-time").html(msec2time(ui.playTime));
		$("#progress-total-time").html(msec2time(ui.playTimeTotal));
	} else {
		$("#progress-current-time").html(msec2time(ui.playTime));
		$("#progress-total-time").html("");
	}
}

function onVolumeChange(ui) {
	/* we have to avoid loops here (e.g. user changes volume in the app, volume
	   is changed in webclient, webclient send volume change notif. to StreamSDK,
	   etc. */
	if (volumeUpdateFromWebclient)
		return;
	volumeUpdateFromStreamSdk = true;
	$("#volume-slider").slider('value', ui.volume);
	setTimeout(function() {
		volumeUpdateFromStreamSdk = false;
	}, 500);
}

function onMuteChange(ui) {
	var img = "";
	if (ui.mute) {
		img = "img/btn/VolumeMute.png";
	} else {
		img = "img/btn/Volume.png";
	}
	$("#btn-mute img").attr("src", img);
}

$(document).ready(function() {
	var browser;
	var player_controller = new PlayerController();

	$("#content-table").tableview({
		per_page: 17
	}).bind("tableviewscroll", function(event, data) {
		console.log(JSON.stringify(data));
		if (browser && browser.page_stack.length > 0)
			browser.page_stack[browser.page_stack.length - 1].scrollTo(data.value);
	});

	browser = new Browser("ui:", "#content-table", player_controller);
	NSDK_PROXY.registerBrowser(browser);

	let lastBrowserWidth = $(document.body).width();
	let lastBrowserHeight = $(document.body).height();

	$(window).resize(function() {
		let itemHeight = $("#item-test").height();
		let browserWidth = $(document.body).width();
		let browserHeight = $(document.body).height();

		/* When keyboard appears on android mobile device there is no specific event except the body height decrease
		   to make the space for the keyboard (see https://stackoverflow.com/a/47798742).
		   We cannot use navigator.userAgent to confirm mobile device because "Mobi" infix is not present while
		   "Desktop site" option is checked. */
		let keyboardAppearEvent = (browserWidth == lastBrowserWidth) && (browserHeight < lastBrowserHeight);

		lastBrowserWidth = browserWidth;
		lastBrowserHeight = browserHeight;

		if (keyboardAppearEvent) {
			// prevent content reloading while editing
			return;
		}

		if ($("#player").hasClass("compact"))
			browserHeight -= $("#player").height();

		let size = Math.floor(browserHeight / itemHeight) - 1; /* -1 because of item-test (contains icon + text) */
		if (!$("#item-level-up").is(":hidden")) {
			// level up button is visible, remove one more line
			size -= 1;
		}
		$("#content-table").tableview("option", "per_page", size);
		if (browser)
			browser.onTableViewPerPageChanged();
	});

	NSDK_Subscribe.subscribe("notifications:/display/queue", "rows", function(event) {
		NSDK_GetRows(event.path, "path", 0, 0)
			.done(function(data) {
				if (data.rows[0]) {
					if (data.rows[0].path.localeCompare($("#notification-middle").attr('title')) != 0) {
						NSDK_GetRows(data.rows[0].path, "title", 0, 0).done(function(message) {
							$("#notification-middle").empty();
							$("#notification-middle").append(message.rows[0].title);
							$("#notification-middle").attr('title', data.rows[0].path);
							$("#notification").show();
						}).fail(function() {
							console.log("NSDK_GetRows failed! Path: " + self.ui.path);
						});
					}
				} else {
					$("#notification").hide();
					$("#notification-middle").attr('title', "");
				}
			}).fail(function() {
				console.log("NSDK_GetRows failed! Path: " + event.path);
			});
	});

	$("#notification-middle").click(function() {
		$("#notification").hide();
		var closePath = {
			"type": "path",
			"path": $("#notification-middle").attr('title')
		}
		NSDK_Activate("notifications:/display/cancel", closePath);
	});

	/* Insert deviceName before title */
	var ret = NSDK_PROXY.browse("settings:/deviceName").done(function(data) {
		document.title = NSDK_PROXY.pageAt(data).get("value").string_ + " - " + document.title;
	});

	/* Bind player controls */
	$("#btn-prev").click(function() {
		player_controller.control("previous");
	});
	$("#btn-next").click(function() {
		player_controller.control("next")
			.fail(function(error) {
				/* Show an error, if there was one */
				onPlaybackErrorShowHide(error.error ? "Player error<br/><br/>" + error.error.message : "");
			});
	});
	$("#btn-shuffle").click(function() {
		player_controller.controlPlayMode("shuffle");
	});
	$("#btn-repeat").click(function() {
		player_controller.controlPlayMode("repeat");
	});
	$("#btn-playpause").click(function() {
		var action = "";
		if (player_controller.ui.buttons.pause || player_controller.ui.state != "playing")
			action = "pause";
		else
			action = "stop";

		player_controller.control(action);
	});
	$("#volume-slider").slider({
		orientation: "horizontal",
		value: 0,
		animate: "slow",
		max: 100,
		min: 0,
		change: function(event, ui) {
			if (volumeUpdateFromStreamSdk)
				return;
			volumeUpdateFromWebclient = true;
			var volume = {
				'type': 'i32_',
				'i32_': ui.value.toString()
			};
			player_controller.setVolume(volume);
			setTimeout(function() {
				volumeUpdateFromWebclient = false;
			}, 500);
		}
	});

	/* set volume slider range dynamically */
	NSDK.getData("player:volume", "edit").done(function(data) {
		$("#volume-slider").slider("option", {
			min: parseInt(data[0].min),
			max: parseInt(data[0].max)
		});
	});

	$("#btn-mute").click(function() {
		var action = "";
		var mute = {
			'type': 'bool_',
			'bool_': !player_controller.ui.mute
		};
		player_controller.setMute(mute)
	});

	$("#progress-background").slider({
		orientation: "horizontal",
		value: 0,
		animate: "slow",
		max: 100,
		min: 0,
		change: function(event, ui) {
			//if there is originalEvent property in the
			//event object then it means the slider was
			//really clicked => seek time, otherwise
			//it means that the value of the slider was
			//changed programmatically
			if (event.hasOwnProperty('originalEvent')) {
				var time = $("#progress-background").slider("option", "value");
				player_controller.control("seekTime", time);
			}
		}
	});

	/* Bind player callbacks */
	player_controller.registerDataChangeHandler(function(ui) {
		onDataStateChange(ui, browser);
	});
	player_controller.registerProgressChangeHandler(onProgressChange);
	player_controller.registerVolumeChangeHandler(onVolumeChange);
	player_controller.registerMuteChangeHandler(onMuteChange);
	player_controller.registerPlayModeChangeHandler(onPlayModeChange);

	/* Bind browser callbacks */
	browser.registerErrorMessageHandlers(onBrowsingError);
	browser.registerWorkingStateChangeHandler(onBrowserWorkingStateChange);
	browser.registerRenderRowsEventHandler(function(page) {
		onRenderRowsEvent(page, browser)
	});

	/* Bind view controls */
	$("#btn-switchview").click(function() {
		switchView(undefined, browser);
	});
	$("#btn-switchlayout").click(function() {
		layout("toggle", browser);
	});
	$("#btn-contextmenu").click(function() {
		browser.openPage(
			player_controller.ui.contextPath, {
				'related': player_controller.currentTrackRoles.mediaData.metaData
			});
		switchView(undefined, browser);
	});

	/* Be able to close browsing error message window */
	$("#browsing-error-container").click(function() {
		$("#browsing-error-container").hide();
	});

	/* Be able to close playback error message window */
	$("#playback-error-container").click(function() {
		$("#playback-error-container").hide();
	});

	$("#content-browser").hide();
	$("#playback-error-container").hide();
	$("#browsing-error-container").hide();

	$("#item-level-up").on('click', function() {
		browser.closePage();
	});

	window.onbeforeunload = function(e) {
		browser.closePage();
		// some webkit-based browsers don't follow the spec for the dialog box.
		// to ensure this code is working on cross-browser we add value to "returnValue"
		// Event property and additionaly as a return value of this function.
		e.returnValue = 'Leaving the page';
		return 'Leaving the page';
	}
});
