#!/bin/sh

# redirect all output to syslog
(
# $1 - The devpath of the device
PHY_NAME_PATH="/sys/$1/phy80211/name"

# start with some reasonable default setting
SOFTAP_INTERFACES="uap0"

# default phy interface
PHY_INTERFACE="phy0"
if [ -f "$PHY_NAME_PATH" ]; then
        PHY_INTERFACE="$(cat $PHY_NAME_PATH)"
fi

# source machine-specific parameters for SoftAP interfaces
[ -e "/etc/wifi/softap_settings.sh" ] && source "/etc/wifi/softap_settings.sh"

for INTERFACE in $(echo $SOFTAP_INTERFACES | tr ',' ' '); do
	if ! ip link show dev "$INTERFACE" &>/dev/null; then
		echo "Adding interface $INTERFACE..."
		iw phy "$PHY_INTERFACE" interface add "$INTERFACE" type __ap
	fi
done

) 2>&1 | logger -s -t softap-init
