#! /bin/sh

# store google cast update file - ota.zip
# yocto symlink /cache -> /system/chrome-cache
cacheFolder=/system/chrome-cache

# google cast data folder
# yocto symlink /data -> /media/settings/google-cast
dataFolder=/media/settings/google-cast

# chrome home folder, storing google cast settings
# gcast_starter -> HOME=/data/chrome/
homeFolder=/data/chrome

# store and read client.crt and client.key.bin
# yocto symlink /factory -> /data/factory
factoryFolder=/data/factory

# folder for local time symlink
# define by google cast as /data/share/chrome
localtimeFolder=/data/share/chrome

# folder for logs from client_cast_auth
# define by google cast as /data/castauth
logFolder=/data/castauth


checkFolder()
{
	if [ ! -d "$1" ]; then
		if [ -e "$1" ]; then
			echo "WARNING: $1 should be a directory but is something else! Removing it."
			rm -f "$1"
		fi
		mkdir -p "$1"
	fi

	# always apply owner/permissions
	chown $2 "$1"
	chmod $3 "$1"
}

# create google cast data folders
checkFolder "$dataFolder" root:root 755
checkFolder "$factoryFolder" root:chrome 775
checkFolder "$cacheFolder" root:chrome 775
checkFolder "$localtimeFolder" chrome:chrome 755
checkFolder "$homeFolder" chrome:chrome 755
checkFolder "$logFolder" root:root 755

# create required symlinks
ln -sf "/tmp" "$logFolder/logs"

if ! [ -L "$factoryFolder/sounds" -a -e "$factoryFolder/sounds" ]; then
	location=`fw_printconst | grep 'googleFactoryLocale' | cut -f 2 -d '='`
	# if googleFactoryLocale in const partition is not set use the default
	if [ -z $location ]; then
		location="en-US"
	fi

	# if sounds for selected location don't exist use the default
	if [ ! -e "/usr/share/factory-sound-effects/$location" ]; then
		location="en-US"
	fi

	rm -rf "$factoryFolder"/sounds
	ln -s /usr/share/factory-sound-effects/$location "$factoryFolder"/sounds
fi

# increment boot id, initiate random number generator
update_bootid_and_urandom.sh

# make sure all the folders and their permissions are synced to flash asap
sync
