#! /bin/sh

PROFILE="/media/settings/settings/network/profile"

is_null_or_empty()
{
	test "x$1" = "x" -o "x$1" = "xnull"
}

# fallback in case the profile is not set
if is_null_or_empty "$(jq -rM .value.networkProfile $PROFILE)"; then
	echo '{"networkProfile":{"wired":{"dhcp":true},"type":"automatic"}}'
else
	cat "$PROFILE" | jq -rM .value
fi
