#!/bin/sh
#
# Lock a113 module
#

set -e

FUSEFILE="/usr/share/factory-tool/files/efuses.bin"

# Print result on script execution
print_result()
{
	if [ $? -eq 0 ]; then
		echo "# done locking device"
	else
		echo "# error locking device"
	fi
}

trap print_result EXIT

# Show error, if there are some parameters provided
if [ $# -ne 0 ]; then
	echo "Error: Command doesn't expect any parameters"
	exit 1
fi

# Check efuses.bin file present
if [ ! -f "$FUSEFILE" ]; then
	echo "Error: Fuse configuration not found"
	exit 1
fi

# Lock a113 module
tee_provision -t 0x51 -i "$FUSEFILE" || exit 1

exit 0
