#!/bin/sh

if [ ! -e "/dev/fb0" ]; then
	# exit immediately in case there is no framebuffer device
	exit 0
fi

send_psplash()
{
	echo "$1" >> "/tmp/psplash_fifo"
}

if [ "$1" = "initialize" ]; then
	# stop any existing psplash processes and
	# clear psplash_fifo
	killall psplash &>/dev/null
	rm "/tmp/psplash_fifo" &>/dev/null

	# create fifo, start psplash
	mkfifo "/tmp/psplash_fifo"
	psplash &

	send_psplash "MSG STARTING..."
fi

if [ "$1" = "copy" ]; then
	if [ "$2" = "progress" ]; then
		send_psplash "MSG LOADING IMAGE..."
		send_psplash "PROGRESS $3"
	fi
fi

if [ "$1" = "update" ]; then
	if [ "$2" = "download" ]; then
		send_psplash "MSG DOWNLOADING..."
		send_psplash "PROGRESS $3"
	elif [ "$2" = "install" ]; then
		send_psplash "MSG step $4 of $3"
		send_psplash "PROGRESS $5"
	elif [ "$2" = "success" ]; then
		send_psplash "MSG SUCCESS"
	elif [ "$2" = "failure" ]; then
		send_psplash "MSG FAILURE"
	fi
fi

if [ "$1" = "exit" ]; then
	send_psplash "MSG QUIT"
fi
