<!DOCTYPE html>
<html>
	<head>
		<meta content="text/html;charset=utf-8" http-equiv="Content-Type">

		<title><?nsdk getData path="settings:/system/modelName" roles="value" escape="html"?> &ndash; Voice Assistant Selection</title>
		<link rel="stylesheet" type="text/css" href="/style/style.css">
		<link rel="stylesheet" type="text/css" href="/style/jquery-ui.min.css">

		<script type="text/javascript" src="/jsapi/jquery.min.js"></script>
		<script type="text/javascript" src="/jsapi/jquery-ui.min.js"></script>
		<script type="text/javascript" src="/jsapi/nsdk-api.js"></script>
		<script type="text/javascript" src="/jsapi/common.js"></script>
		<script type="text/javascript" src="/scripts/menu.js.fcgi"></script>

		<script type="text/javascript">
			var activeAssistant = '<?nsdk getData path="settings:/system/activeAssistant" roles="value" escape="js"?>';
			var assistantList = JSON.parse('<?nsdk getData path="master:assistantList" roles="value" escape="js"?>');

			function refreshPage() {
				$.ajax({url: window.location.href, timeout: 1000, cache: false})
					.done(function() {
						window.location.reload(true);
					})
					.fail(function() {
						setTimeout(refreshPage, 1000);
					});
			}

			function onVoiceAssistanConfirmed() {
				$("#assistantConfirm").attr("disabled", true)

				$("#dialog").dialog("option", "title", "Selecting voice assistant...")
				$("#dialog").html('Please wait for the device to finish selecting the voice assistant, webpage will refresh automatically...')
				$("#dialog").dialog("open")

				var selectedValue = $('input[name=assistantRadio]:checked', '#assistant_selector').val()
				NSDK_WriteValue("settings:/system/activeAssistant", {"type": "string_", "string_" : selectedValue})
					.always(function() {
						NSDK_Activate("powermanager:goReboot")
							.always(function() {
								setTimeout(refreshPage, 10000);
							})
					})
			}

			$(document).ready(function() {
				// initialize the dialog
				$('#dialog').dialog({
					autoOpen: false
				});

				// disable the confirm button at first
				$("#assistantConfirm").attr("disabled", true)

				// create inputs based on the assistant list
				assistantList.stringList.forEach(function(assistant) {
					var radioInput = $('<input/>',
					{
						type: 'radio',
						name: 'assistantRadio',
						value: assistant,
						checked: (assistant == activeAssistant),
						change: function() {
							// disable the confirm button if the currently active assistant is selected
							$("#assistantConfirm").attr("disabled", (this.value == activeAssistant))
						}
					});

					$("#assistantRadioArea").append(radioInput, assistant, "<br>")
				})
			});
		</script>

	</head>

	<body>
		<div id="menu"></div>

		<fieldset id="assistant_selector">
			<legend>Select Active Voice Assistant</legend>
			<dl>
				<dt><label id="type">Select your voice assistant</label></dt>
				<dd id="assistantRadioArea">
				</dd>
			</dl>
		</fieldset>
		<button id="assistantConfirm" type="button" onclick="onVoiceAssistanConfirmed()">Confirm</button><br>
		<div id="dialog"></div>
	</body>
</html>
