<!DOCTYPE html>
<html>
	<head>
		<meta content="text/html;charset=utf-8" http-equiv="Content-Type">

		<title><?nsdk getData path="settings:/system/modelName" roles="value" escape="html"?> &ndash; First Time Setup</title>
		<link rel="stylesheet" type="text/css" href="/style/style.css">
		<link rel="stylesheet" type="text/css" href="/style/jquery-ui.min.css">

		<script type="text/javascript" src="/jsapi/jquery.min.js"></script>
		<script type="text/javascript" src="/jsapi/jquery-ui.min.js"></script>
		<script type="text/javascript" src="/jsapi/nsdk-api.js"></script>
		<script type="text/javascript" src="/jsapi/common.js"></script>

		<script type="text/javascript">
			var networkInfo = JSON.parse('<?nsdk getData path="network:info" roles="value" escape="js"?>');
			var networkConfigured = '<?nsdk getData path="settings:/www/ftsNetwork" roles="value" escape="js"?>';

			var timeZoneConfigured = '<?nsdk getData path="settings:/www/ftsTimeZone" roles="value" escape="js"?>';

			var googleCastConfigured = '<?nsdk getData path="settings:/www/ftsGoogleCast" roles="value" escape="js"?>';
			var googlecast = '<?nsdk getData path="googlecast:/assistantState" roles="value" escape="js"?>';
			var tosAccepted = '<?nsdk getData path="settings:/googlecast/tosAccepted" roles="value" escape="js"?>';

			var firmwareUpdateTimer = null;
			var firmwareUpdateChecking = false;
			var firmwareUpdateButtonAction = "continue";
			var firmwareUpdateMaxIdle = 0;

			var networkRepeatTime = 1500;
			var networkConnectTime = 30000;
			var networkStartTime = 0;

			var ftsSteps = [];

			$(document).ready(function() {
				if ('<?nsdk getData path="settings:/www/ftsComplete" roles="value" escape="js"?>' == "true" ||
					tosAccepted == "true") {
					window.location.replace("index.fcgi");
				}

				$("#dialog").dialog({
					autoOpen: false
				});

				ftsSteps.push("start");
				// show network configuration only in softap mode
				if (networkConfigured == "false" &&
					networkInfo.networkInfo != undefined &&
					networkInfo.networkInfo.softAp.state == "up") {
					ftsSteps.push("network");
				} else {
					var data = {"bool_": true , "type": "bool_"};
					NSDK_SetData("settings:/www/ftsNetwork", data);
				}
				if (timeZoneConfigured == "false") {
					ftsSteps.push("timezone");
				}
				// show google cast configuration if is google cast installed and tos is not accepted
				if (googleCastConfigured == "false" && !googlecast.startsWith('[[')) {
					ftsSteps.push("google");
				}
				ftsSteps.push("update");
				ftsSteps.push("finish");
				ftsMakeStep();
			});

			function ftsMakeStep() {
				if (ftsSteps.length == 0) {
					var data = {"bool_": true , "type": "bool_"};
					NSDK_SetData("settings:/www/ftsComplete", data).always(function() {
						window.location.replace("index.fcgi");
					});
				} else {
					var action = ftsSteps.shift();
					if (action == "start") {
						firstTimeSetupStart();
					}
					else if (action == "timezone") {
						timezoneFtsConfigure();
					}
					else if (action == "network") {
						networkFtsConfigure();
					}
					else if (action == "google") {
						googlecastFtsConfigure();
					}
					else if (action == "update") {
						updateFtsConfigure();
					}
					else if (action == "finish") {
						firstTimeSetupFinish();
					}
					else {
						ftsMakeStep();
					}
				}
			}

			function firstTimeSetupStart() {
				$("#startFts").show();
			}

			function firstTimeSetupStartContinue() {
				var deviceName = $("#startFtsDeviceName").val();
				if (deviceName == "") {
					alert("Device name cannot be empty");
				}
				else {
					NSDK_SetData("settings:/deviceName", deviceName, "value");
					$("#startFts").hide();
					ftsMakeStep();
				}
			}

			function timezoneFtsConfigure() {
				NSDK_GetData("timemanager:/availableCountries", "value").done(function(data) {
					var countries = data.value.timeManagerCountries.countries;
					var it = 0;
					$.each(countries, function(code, name) {
						++it;
						$('#timezoneFtsSelect').append($('<option>', {"value": name.countryCode}).text(name.countryName));
					});

					$("#timezoneFts").show();
				})
				.fail( function() {
					// path doesn't exist, skip this step
					NSDK_SetData("settings:/www/ftsTimeZone", {"bool_": true , "type": "bool_"});
					ftsMakeStep();
				});
			}

			function timezoneFtsSelectChange() {
				var countryCode = $('#timezoneFtsSelect').val();
				$("#timezoneFtsButton").html('Continue');
				if (countryCode == "-1") {
					$("#timezoneFtsButton").prop('disabled', true);
				}
				else {
					countryObj = {"type": "string_", "string_" : countryCode};
					NSDK_SetData("settings:/locationCountry", countryObj);
					NSDK_Activate("timemanager:/regionsForCountry", countryObj).always(function(data) {
						timezoneFtsUpdateRegions(data);
						$("#timezoneFtsButton").prop('disabled', false);
					});
				}
			}

			function timezoneFtsUpdateRegions(regions) {
				var regions = regions.stringList;
				$('#timezoneFtsRegionSelect').empty()
				$.each(regions, function(code, name) {
					$('#timezoneFtsRegionSelect').append($('<option>', {"value": name}).text(name));
				});
				if (regions.length < 2) {
					$("#timezoneFtsRegionSelect").prop('disabled', true);
				}
				else {
					$("#timezoneFtsRegionSelect").prop('disabled', false);
				}
			}

			function timezoneFtsRegionSelectChange() {
				var region = $('#timezoneFtsRegionSelect').val();
				NSDK_SetData("settings:/locationRegion", {"type": "string_", "string_" : region});
			}

			function timezoneFtsContinue() {
				NSDK_SetData("settings:/www/ftsTimeZone", {"bool_": true , "type": "bool_"});
				$("#timezoneFts").hide();
				ftsMakeStep();
			}

			function networkFtsConfigure() {
				$("#networkFtsContent").load("networkContent.fcgi");
				$("#networkFts").show();
			}

			function requestDummySoftAp() {
				NSDK_Activate("network:requestSoftAp", {"type":"networkSoftApRequest",
					"networkSoftApRequest": {"name": "www", "timeout": networkConnectTime, "holdSoftAp": true}});
			}

			function revokeDummySoftAp() {
				NSDK_Activate("network:revokeSoftAp", {"type":"networkSoftApRequest",
					"networkSoftApRequest": {"name": "www"}});
			}

			function setNetworkProfile(profile, info) {
				// check if we are connected over softAp
				if (info !== undefined && info.networkInfo !== undefined && info.networkInfo.softAp !== undefined &&
							info.networkInfo.softAp.state == "up") {
					requestDummySoftAp();
				}

				NSDK_Activate("network:setNetworkProfile", profile).done(function() {
					networkStartTime = performance.now();
					setTimeout(getNewIpAddress, networkRepeatTime);
					$("#dialog").dialog("option", "title", "Network settings...");
					$("#dialog").html('Applying network settings...');
					$("#dialog").dialog("widget").find('.ui-dialog-titlebar-close').remove();
					$("#dialog").dialog("open");
				}).fail(function() {
					revokeDummySoftAp();
					alert("Applying the new network settings failed");
				});
			}

			function setNetworkFinished(ip) {
				// show dialog with redirect link
				revokeDummySoftAp();
				$("#dialog").html("Please wait till your device connects to selected network and " +
					"continue <a href=//"+ ip + "/fts.fcgi>here</a>");
			}

			function setNetworkTimeout() {
				revokeDummySoftAp();
				$("#dialog").dialog("close");
				alert("Applying the new network settings failed");
			}

			function getNewIpAddress() {
				NSDK_GetData("network:info", "value").done(function(result) {
					var profile = result["value"];

					if (performance.now() - networkStartTime > networkConnectTime) {
						setNetworkTimeout();
						return;
					}

					var reload = false, ip;
					if (profile.networkInfo && profile.networkInfo.wireless && profile.networkInfo.wireless.state == "up" &&
							profile.networkInfo.wireless.addresses && profile.networkInfo.wireless.addresses[0].ip) {
						ip = profile.networkInfo.wireless.addresses[0].ip;
						reload = true;
					}

					if (profile.networkInfo && profile.networkInfo.wired &&  profile.networkInfo.wired.state == "up" &&
							profile.networkInfo.wired.addresses && profile.networkInfo.wired.addresses[0].ip) {
						ip = profile.networkInfo.wired.addresses[0].ip;
						reload = true;
					}

					if (reload) {
						// network set successfully
						NSDK_SetData("settings:/www/ftsNetwork", {"bool_": true , "type": "bool_"});
						setNetworkFinished(ip);
					} else {
						console.log("Wired and Wireless connection undefined/down");
						setTimeout(getNewIpAddress, networkRepeatTime);
					}
				})
				.fail(function() {
					if (performance.now() - networkStartTime > networkConnectTime) {
						setNetworkTimeout();
						networkFtsConfigureFinish();
					} else {
						setTimeout(getNewIpAddress, networkRepeatTime);
					}
				});
			}

			function networkFtsConfigureFinish() {
				$("#networkFts").hide();
				NSDK_SetData("settings:/www/ftsNetwork", {"bool_": true , "type": "bool_"});
				$("#networkFtsContent").empty();
				ftsMakeStep();
			}

			function googlecastFtsConfigure() {
				$("#googlecastFts").show();
			}

			function googlecastFtsComplete() {
				var data = {"bool_": true , "type": "bool_"};
				NSDK_SetData("settings:/www/ftsGoogleCast", data);
				$("#googlecastFts").hide();
				ftsMakeStep();
			}
			function updateFtsConfigure() {
				$("#updateFts").show();
				var check = {"firmwareUpdateOptions": {"autoDownload": "false", "disableAutoInstall": "false"}};
				NSDK_Activate("firmwareupdate:checkForUpdate", check).done(function(data) {
					if (data != null) {
						if (data.forcedUpdate) {
							$("#updateFtsText").html("Required update found<br> Downloading & installing: " + data.version + "<br>Please wait for the device to start");
						}
						else {
							firmwareUpdateButtonAction = "update";
							$("#updateFtsText").html("New version found: " + data.version);
							$("#updateFtsContinue").html("Update");
							$("#updateFtsContinue").attr("disabled", false);
							$("#updateFtsSkip").show();
						}
					}
					else {
						firmwareUpdateButtonAction = "continue";
						$("#updateFtsText").html("No new update available");
						$("#updateFtsContinue").html("Continue");
						$("#updateFtsContinue").attr("disabled", false);
					}
				})
				.fail( function() {
					// path doesn't exist, skip this step
					$("#updateFts").hide();
					ftsMakeStep();
				});
			}

			function updateFtsIntervalDownloading() {
				NSDK_GetData("firmwareupdate:updateStatus", "value").always(function(data) {
					var updateState = data.value.firmwareUpdateStatus.state || null;
					if (updateState == "newUpdateAvailable") {
						// wait for dowloading state
					}
					else if (updateState == "downloading") {
						$("#updateFtsText").html("Wait for downloading finished <br>Downloading: " + data.value.firmwareUpdateStatus.downloadProgress + " %");
					}
					else if (updateState == "downloaded") {
						$("#updateFtsText").html("Device is installing, wait for device boot up");
						$("#updateFtsContinue").prop("disabled", true);
						clearInterval(firmwareUpdateTimer);
					}
					else {
						clearInterval(firmwareUpdateTimer);
						updateFtsDownloadFailed();
					}
				});
			}

			function updateFtsConfigureFinish() {
				if (firmwareUpdateButtonAction == "continue") {
					updateFtsConfigureSkip();
				}
				else if (firmwareUpdateButtonAction == "update") {
					// start update
					NSDK_Activate("firmwareupdate:downloadNewUpdate", {}).done(function(data) {
						firmwareUpdateTimer = setInterval(updateFtsIntervalDownloading, 500);
						$("#updateFtsSkip").hide();
						$("#updateFtsContinue").html("Abort");
						$("#updateFtsContinue").prop("disabled", false);
						firmwareUpdateButtonAction = "abort";
					});
				}
				else if (firmwareUpdateButtonAction == "abort") {
					NSDK_Activate("firmwareupdate:cancelDownloading", {});
					updateFtsConfigureSkip();
				}
			}

			function updateFtsDownloadFailed() {
				$("#updateFtsSkip").hide();
				$("#updateFtsText").html("Firmware update failed");
				$("#updateFtsContinue").html("Continue");
				$("#updateFtsContinue").prop("disabled", false);
				firmwareUpdateButtonAction = "continue";
			}

			function updateFtsConfigureSkip() {
				clearInterval(firmwareUpdateTimer);
				$("#updateFts").hide();
				ftsMakeStep();
			}

			function firstTimeSetupFinish() {
				$("#finishFts").show();
			}

			function firstTimeSetupFinishContinue() {
				$("#finishFts").hide();
				ftsMakeStep();
			}
		</script>
	</head>

	<body>

		<fieldset hidden id="startFts">
			<legend>First time setup start</legend>
			<p>Lets configure your device in a few simple steps</p>
			<p>Device name:
				<input id="startFtsDeviceName" type="text" value="<?nsdk getData path="settings:/deviceName" roles="value" escape="html"?>"/>
			</p>
			<button onclick="firstTimeSetupStartContinue()">Continue</button>
		</fieldset>

		<fieldset hidden id="timezoneFts">
			<legend>Timezone</legend>
			<p> Set your country, and region if required, to locate your product and set the time zone.<br><br>
			Choose country: <select id=timezoneFtsSelect onchange="timezoneFtsSelectChange();">
				<option value="-1">Select country</option>
			</select> <br><br>
			Choose region: <select disabled id=timezoneFtsRegionSelect onchange="timezoneFtsRegionSelectChange();">
				<option value="-1">none</option>
			</select>
			</p>
			<button id="timezoneFtsButton" onclick="timezoneFtsContinue()">Skip</button>
		</fieldset>

		<fieldset hidden id="googlecastFts">
			<legend>Google cast</legend>
			<p>The <a href="http://www.google.com/intl/en/policies/privacy/">Google Privacy Policy</a> describes the information that Google collects
			during your set-up and use of Google Cast. You can modify your device’s Google Cast privacy settings, such as whether it sends usage data
			and crash reports to Google, after you have set up your device by accessing the device settings in this application.</p>

			<p id="acceptFalse">Please use your Google Home application to accept <a href="http://www.google.com/intl/en/policies/terms/">Google Terms
			of Service</a> and <a href="http://www.google.com/intl/en/policies/privacy/ ">Google Privacy Policy</a></p>
			<button onclick="googlecastFtsComplete()">Done</button>
		</fieldset>

		<div hidden id="networkFts">
			<div id=networkFtsContent></div>
			<div hidden id="dialog"></div>
			<button onclick="networkFtsConfigureFinish()">Skip</button>
		</div>

		<fieldset hidden id="updateFts">
			<legend>Firmware update</legend>
			<p>Firmware version: <?nsdk getData path="settings:/version" roles="value" escape="html"?></p>
			<p id="updateFtsText">Checking for update...</p>
			<button disabled id="updateFtsContinue" onclick="updateFtsConfigureFinish()">Continue</button>
			<button hidden id="updateFtsSkip" onclick="updateFtsConfigureSkip()">Skip</button>
		</fieldset>

		<fieldset hidden id="finishFts">
			<legend>First time setup end</legend>
			<p>Your device is configured and ready to play</p>
			<button onclick="firstTimeSetupFinishContinue()">Continue</button>
		</fieldset>
	</body>
</html>
