<!DOCTYPE html>
<html>
	<head>
		<meta content="text/html;charset=utf-8" http-equiv="Content-Type">

		<title><?nsdk getData path="settings:/system/modelName" roles="value" escape="html"?> &ndash; OAuth2 Page</title>
		<link rel="stylesheet" type="text/css" href="/style/style.css">

		<script type="text/javascript" src="/jsapi/jquery.min.js"></script>
		<script type="text/javascript" src="/jsapi/nsdk-api.js"></script>
		<script type="text/javascript" src="/jsapi/common.js"></script>
		<script type="text/javascript" src="/scripts/menu.js.fcgi"></script>

		<script type="text/javascript">
			var oauthServices = {}

			function showNA(serviceId, msg, clear)
			{
				if (clear) {
					$(serviceId +"-logout").html("");
					$(serviceId +"-login").html("");
				} else {
					$(serviceId +"-logout").hide();
					$(serviceId +"-login").hide();
				}
				$(serviceId +"-na").html("<p>" + msg + "</p>");
				$(serviceId +"-na").show();
			}

			function statusChanged(serviceId, status)
			{
				$("#" + serviceId +"-na").hide();
				$("#" + serviceId +"-logout").hide();
				$("#" + serviceId +"-login").hide();
				if (status == 'notAvailable') {
					showNA("Module is not available.", true);
				} else if (status == 'noNetwork') {
					showNA("Network is not available.", false);
				} else if (status == 'loginRequired') {
					$("#" + serviceId +"-login").show();
				} else {
					$("#" + serviceId +"-logout").show();
				}
			}

			function fetchData(path, serviceId)
			{
				NSDK_GetData(path, "value").done(function(data) {
					if (data.value.bool_ === false) {
						statusChanged(serviceId, 'loginRequired');
					}
					if (data.value.bool_ === true) {
						statusChanged(serviceId, 'login');
					}
				});
			}

			function login(serviceId)
			{
				// Disable all login/logout buttons
				$("#oauthContent :input").prop("disabled", true)

				// Change the clicked button's text to 'Logging in'
				$("#" + serviceId + "-login :input").text("Logging in")

				// Retrieve service login data
				NSDK_GetData(oauthServices[serviceId].loginUrl, "value")
					.done(function(data) {
						var loginData = data.value.oauth2LoginData

						// Construct URL for the cloud
						var url = new URL(loginData.redirectUri)
						url.searchParams.append("url", btoa(loginData.url))
						url.searchParams.append("key", btoa(loginData.rsaPubKey))
						url.searchParams.append("clientInfo", btoa(loginData.clientInfo))

						// Tell the cloud to redirect to this page (also, remember which service it came from)
						var redirectUrl = new URL(window.location.href)
						redirectUrl.searchParams.append("servicePath", oauthServices[serviceId].path)
						url.searchParams.append("redirectUrl", btoa(redirectUrl.toString()))

						// Construct and execute the POST request
						var form = $(`<form action="${url.toString()}" method="post"></form>`)
						$('body').append(form)
						form.submit()
					})
					.fail(function() {
						NSDK_Activate(oauthServices[serviceId].codeUrl)
							.done(function(data) {
								let divLoginId = serviceId + "-login";
								$("#" + divLoginId).html(`<p>
									Please navigate to: <a href=${data.url}>${data.url}</a> <br>
									to enter the fallowing code: "${data.code}"
								</p>`);
								NSDK_Subscribe.subscribe(oauthServices[serviceId].path + "/loggedIn", "itemWithValue", function(event) {
									if (event.itemValue && event.itemValue.bool_ == true)
										location.reload();
								})
							})
							.fail(function() {
								alert("Unable to retrieve service data!")
							});
					});
			}

			function logout(serviceId, serviceTitle)
			{
				if (confirm(`Are you sure you want to logout from ${serviceTitle}?`)) {
					NSDK_Activate(oauthServices[serviceId].path + "/removeToken").done(function() {
						statusChanged(serviceId, 'loginRequired');
					});
				}
			}

			$(document).ready(function() {
				// This site might be invoked in two ways, first as a menu item on the webpage (the normal
				// use case), and second, at the end of the login process, where we get the encrypted
				// authorization code or an error message from our cloud. In the latter case, we expect
				// to see "code", "state" and "aesKey" query parameters in the successful case, "error", "state"
				// and possibly also "error_description" in the error case. So, if these queries are present,
				// we'll treat this invocation as the second case, otherwise as the first one.
				var currentUrl = new URL(window.location.href)
				var state = currentUrl.searchParams.get("state")

				if (state === null) {
					NSDK_GetRows("oauth2:/service", "title,path", 0, 100).done(function(data) {
						if (data.rowsCount > 0) {
							// We have at least one service using OAuth

							for (var i = 0; i < data.rowsCount; i++) {
								// Unique service identifier that can be used in divs (i. e. has no spaces)
								let serviceId = "service-" + i
								let serviceTitle = data.rows[i].title
								let servicePath = data.rows[i].path
								let loginUrl = servicePath + "/loginData"
								let codeUrl = servicePath + "/deviceCodeLinking"

								oauthServices[serviceId] = {
									"title": serviceTitle,
									"path": servicePath,
									"loginUrl": loginUrl,
									"codeUrl": codeUrl
								}

								let divNotAvailableId = serviceId + "-na"
								let divLoginId = serviceId + "-login"
								let divLogoutId = serviceId + "-logout"

								// Generate entry for each OAuth service
								$("#oauthContent").append(`
									<fieldset id="${serviceId}">
										<legend>${serviceTitle}</legend>
										<div id="${divNotAvailableId}" style="display: none"></div>
										<div id="${divLoginId}" style="display: none">
											<p>Click on the button below to login or register.</p>
											<button id="link" type="button" name="linkButton" onclick="login('${serviceId}')">Login</button>
										</div>
										<div id="${divLogoutId}" style="display: none">
											<p>You are already logged in.</p>
											<p>If you want to unlink the device from your account click the button below.</p>
											<button type="button" id="unlink" name="unlinkButton" onclick="logout('${serviceId}', '${serviceTitle}')">Logout</button>
										</div>
									</fieldset>
								`)
							}

							// Check each service's logged-in state
							for (var service in oauthServices) {
								fetchData(oauthServices[service].path + "/loggedIn", service)
							}
						}
						else {
							// No services use OAuth
							$("#oauthContent").html("<p>There are no services using OAuth2 authentication on this build</p>")
						}

					}).fail(function() {
						alert("Unable to get OAuth service information")
					});
				}
				else {
					var authCode = currentUrl.searchParams.get("code")
					var error = currentUrl.searchParams.get("error")

					if (authCode !== null) {
						var aesKey = currentUrl.searchParams.get("aesKey")
						var servicePath = currentUrl.searchParams.get("servicePath")

						// Sanity check
						if (aesKey === null || servicePath === null) {
							alert("Code is present, but aesKey or servicePath are not!")
							return
						}

						var oauth2Code = {
							"type": "oauth2AuthResponse",
							"oauth2AuthResponse": {
								"encryptedCode": authCode,
								"state": state,
								"aesKey": aesKey,
							}
						}

						$('#oauthContent').html("<p>Logging in...</p>")

						NSDK_SetData(servicePath + "/loginData", oauth2Code, "value")
							.done(function() {
								// Reload the current page on OK, but without query params
								$('#oauthContent').html(`
									<fieldset>
										<legend>Login Status</legend>
										<p>Login was successful!</p>
										<p><a href='oauth.fcgi'>OK</a></p>
									</fieldset>
								`);
							})
							.fail(function(e) {
								$('#oauthContent').html(`
									<fieldset>
										<legend>Login Status</legend>
										<p>Login failed: ${e.error.message}</p>
										<p><a href='oauth.fcgi'>OK</a></p>
									</fieldset>
								`);
							})
					}
					else if (error !== null) {
						var errorToPrint = error

						var errorDescription = currentUrl.searchParams.get("error_description")
						if (errorDescription !== null) {
							errorToPrint += ", "
							errorToPrint += errorDescription
						}
						$('#oauthContent').html(`
							<fieldset>
								<legend>Login Status</legend>
								<p>Login failed: ${errorToPrint}</p>
								<p><a href='oauth.fcgi'>OK</a></p>
							</fieldset>
						`)
					}
				}

			});

		</script>
	</head>

	<body>
		<div id="menu"></div>
		<div id="oauthContent"></div>
	</body>
</html>
