(function($) {
	$.widget("nsdk.tableview", {
		options: {
			value: 0,
			count: 0,
			per_page: 10,
			delay: 0
		},

		_scrolled: function() {
			var new_top = this.element.find(".nsdk-content-slider").slider('option', 'max') - this.element.find(".nsdk-content-slider").slider("value");
			if (new_top > -1) {
				this._trigger("scroll", null, {
					value: new_top
				});
			}
		},

		_create: function(settings) {
			var self = this;
			this.options = $.extend(this.options, settings);

			// there is only one .nsdk-content-slider within the tableview
			this.$slider = $("<div/>", {
				class: "nsdk-content-slider"
			});

			// there is only one .nsdk-content-table within the tableview
			this.element.append($("<div/>", {
				class: "nsdk-content-table",
			}));

			this.activeItemChangedHandler = null;

			// handle click on any part of the item: icon, item-name or context
			this.element.on('click', '.nsdk-content-table > .item > *', function(event) {
				var id;
				if ($(event.currentTarget).attr('class')) {
					id = parseInt($(event.currentTarget).parent().attr('data-id'));
					if (self.activeItemChangedHandler) {
						self.activeItemChangedHandler({
							id: id,
							context: $(event.currentTarget).attr('class') == 'context'
						});
					}
					event.stopPropagation();
				}
			});

			for (var i = 0; i < this.options.per_page; ++i) {
				this.element.find(".nsdk-content-table").append($("<div/>", {
					class: "item item-type-disabled",
					"data-id": '' + i
				}));
			}

			this.element.append(this.$slider);
			var scroller = this._scrolled.bind(this);
			var element = this;

			this.element.find(".nsdk-content-slider").slider({
				orientation: "vertical",
				range: "min",
				value: this.options.value + this.options.count - 1,
				min: 0,
				max: this.options.count - this.options.per_page,
				change: scroller,
				slide: scroller,
				stop: function(event, ui) {}
			});

			this.element.mousewheel(function(e) {
				e.preventDefault(); //has to be added because of the Safari 9+ browser's
				//elastic scrolling. https://github.com/jquery/jquery-mousewheel/issues/156
				var value = self.element.find(".nsdk-content-slider").slider("value");
				setTimeout(function() {
					value += e.deltaY;
					if (value >= 0 && value <= self.element.find(".nsdk-content-slider").slider("option", "max")) {
						self.element.find(".nsdk-content-slider").slider("value", value);
					}
				});
			});

			this._update_scrollbar();

			return this;
		},

		renderPage: function(data) {
			var limit = data.length;
			if (limit > this.options.per_page) {
				limit = this.options.per_page;
			}
			for (var i = 0; i < limit; ++i) {
				this.element.find(".nsdk-content-table > .item[data-id='" + i + "']").html(data[i].html);
				this.element.find(".nsdk-content-table > .item[data-id='" + i + "']").attr('class', data[i].class);
				this.element.find(".nsdk-content-table > .item[data-id='" + i + "']").css("visibility", "visible");
			}
			for (i = limit; i < this.options.per_page; ++i) {
				this.element.find(".nsdk-content-table > .item[data-id='" + i + "']").css("visibility", "hidden");
			}
		},

		registerActiveItemChangedHandler: function(handler) {
			this.activeItemChangedHandler = handler;
		},

		_setOption: function(key, value) {
			var self = this;
			var prev = this.options[key];
			this._super(key, value);
			if (key == "count" && prev != value) {
				if (value < this.options.per_page) {
					this.element.find(".nsdk-content-slider").slider("option", "max", 0);
				} else {
					this.element.find(".nsdk-content-slider").slider("option", "max", value - this.options.per_page);
					this.element.find(".nsdk-content-slider").slider("option", "value", value - this.options.per_page);
				}
			} else if (key == "per_page" && value != prev) {
				if (prev < value) {
					for (let i = prev; i < value; ++i) {
						this.element.find(".nsdk-content-table").append($("<div/>", {
							class: "item item-type-disabled",
							"data-id": '' + i
						}));
					}
				} else {
					let children = this.element.find(".nsdk-content-table").children();
					for (let i = value; i < prev; ++i)
						if (value >= 0) $(children[i]).remove();
				}
				this.element.find(".nsdk-content-slider").slider("option", "max", this.options.count - this.options.per_page);
				this.element.find(".nsdk-content-slider").slider("option", "value", this.options.count - this.options.per_page);
			} else if (key == "value" && value != prev) {
				this.element.find(".nsdk-content-slider").slider("option", "value", this.options.count - this.options.per_page - value);
			}
			this._update_scrollbar();
		},

		_update_scrollbar: function() {
			if (this.options.count > this.options.per_page) {
				this.element.find(".nsdk-content-slider").show();
			} else {
				this.element.find(".nsdk-content-slider").hide();
			}
		},

		_destroy: function() {
			this.element
				.removeClass('tableview')
				.empty();
		}
	});
})(jQuery);
