#!/bin/sh
# swupdate's post-update script

# Since downgrade is not allowed, and there are new rules for reinstaling/upgrading
# the enviroments, not all enviroments must be reinstalled/upgraded as before, so we rewrite
# version of only those enviroments that were reinstalled/upgraded and their names 
# and version were written to file. For backward compatibility, we leave the original
# piece of code that overwrites the versions of the environments from the input arguments.

FILE=/tmp/env_updated

if test -f "$FILE"; then
	while IFS= read -r line
	do
		fw_setenv $line
	done < "$FILE"
else
	for var in "$@"
	do
		echo "$var"
		fw_setenv  $(echo ${var} | tr '=' ' ')
	done
fi
# be aware content of swupdate_postinstall_common is inserted before this line in do_deploy
