#!/usr/bin/env sh

FW_PRINTCONST=/sbin/fw_printconst

# redirect all output to kernel log (we cannot use syslog beacuse this
# script is run before /var is mounted).
(
eth_addr=`$FW_PRINTCONST eth_int_addr`

if [ $? -eq 0 ]; then
	eth_addr=`echo $eth_addr | awk -F= '{print $2}'`
	echo "const-eth-init.sh: setting eth0 MAC address to $eth_addr"
	ip link set eth0 address $eth_addr
else
	echo "const-eth-init.sh: could not get eth0 MAC address from const partition"
fi
) 2>&1 > /dev/kmsg

exit 0

