#! /bin/sh
#
# Get unique id of device

set -e

show_help()
{
cat << EOF
Usage:
	factory_tool get_unique_id

Description:
	Get unique id of device.

Parameters:
	This command doesn't expect any parameters.

EOF
}

# Check for help or other parameters
if [ $# -eq 1 ] && [ "$1" = "help" ]; then
	show_help
	exit 0
elif [ $# -ne 0 ]; then
	echo "Error: Command doesn't expect any parameters"
	show_help
	exit 1
fi

uniqueid="$(cat /proc/cpuinfo | grep Serial | sed 's/.*: //')"

if test -n "$uniqueid"
then
	echo $uniqueid
	exit 0
fi

exit 1
